/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.formula;

import net.lulihu.ObjectKit.StrKit;
import net.lulihu.formula.ExpressionNodeType;

public class ExpressionNode {
    private String value;
    private ExpressionNodeType type;
    private int pri;
    private ExpressionNode unitaryNode;
    private Object numeric;

    public ExpressionNode(String value) {
        this.value = value;
        this.type = this.parseNodeType(value);
        this.pri = this.getNodeTypePRI(this.type);
        this.numeric = null;
    }

    public Object getNumeric() {
        if (this.numeric == null) {
            if (this.type == ExpressionNodeType.String || this.type == ExpressionNodeType.Date) {
                return this.value;
            }
            if (this.type != ExpressionNodeType.Numeric) {
                return 0;
            }
            Double num = new Double(this.value);
            if (this.unitaryNode != null && this.unitaryNode.type == ExpressionNodeType.Subtract) {
                num = 0.0 - num;
            }
            this.numeric = num;
        }
        return this.numeric;
    }

    public void setNumeric(Object numeric) {
        this.numeric = numeric;
        this.value = this.numeric.toString();
    }

    public void setUnitaryNode(ExpressionNode unitaryNode) {
        this.unitaryNode = unitaryNode;
    }

    private ExpressionNodeType parseNodeType(String value) {
        if (StrKit.isEmpty(value)) {
            return ExpressionNodeType.Unknown;
        }
        switch (value) {
            case "+": {
                return ExpressionNodeType.Plus;
            }
            case "-": {
                return ExpressionNodeType.Subtract;
            }
            case "*": {
                return ExpressionNodeType.MultiPly;
            }
            case "/": {
                return ExpressionNodeType.Divide;
            }
            case "%": {
                return ExpressionNodeType.Mod;
            }
            case "^": {
                return ExpressionNodeType.Power;
            }
            case "(": {
                return ExpressionNodeType.LParentheses;
            }
            case ")": {
                return ExpressionNodeType.RParentheses;
            }
            case "&": {
                return ExpressionNodeType.BitwiseAnd;
            }
            case "|": {
                return ExpressionNodeType.BitwiseOr;
            }
            case "&&": 
            case "<\u5e76\u4e14>": 
            case "\u5e76\u4e14": {
                return ExpressionNodeType.And;
            }
            case "||": 
            case "<\u6216\u8005>": 
            case "\u6216\u8005": {
                return ExpressionNodeType.Or;
            }
            case "!": {
                return ExpressionNodeType.Not;
            }
            case "==": 
            case "=": {
                return ExpressionNodeType.Equal;
            }
            case "!=": 
            case "<>": 
            case "\u2260": {
                return ExpressionNodeType.Unequal;
            }
            case ">": {
                return ExpressionNodeType.GT;
            }
            case "<": {
                return ExpressionNodeType.LT;
            }
            case ">=": 
            case "\u2265": {
                return ExpressionNodeType.GTOrEqual;
            }
            case "<=": 
            case "\u2264": {
                return ExpressionNodeType.LTOrEqual;
            }
            case "<<": {
                return ExpressionNodeType.LShift;
            }
            case ">>": {
                return ExpressionNodeType.RShift;
            }
            case "@": 
            case "<\u5305\u542b>": 
            case "\u5305\u542b": {
                return ExpressionNodeType.Like;
            }
            case "!@": 
            case "<\u4e0d\u5305\u542b>": 
            case "\u4e0d\u5305\u542b": {
                return ExpressionNodeType.NotLike;
            }
            case "!!$": {
                return ExpressionNodeType.StartWith;
            }
            case "!!@": {
                return ExpressionNodeType.EndWith;
            }
        }
        if (this.isNumerics(value)) {
            return ExpressionNodeType.Numeric;
        }
        if (ExpressionNode.isDatetime(value)) {
            return ExpressionNodeType.Date;
        }
        if (value.contains("\"")) {
            return ExpressionNodeType.String;
        }
        return ExpressionNodeType.Unknown;
    }

    private int getNodeTypePRI(ExpressionNodeType nodeType) {
        switch (nodeType) {
            case LParentheses: 
            case RParentheses: {
                return 9;
            }
            case Not: {
                return 8;
            }
            case Mod: {
                return 7;
            }
            case MultiPly: 
            case Divide: 
            case Power: {
                return 6;
            }
            case Plus: 
            case Subtract: {
                return 5;
            }
            case LShift: 
            case RShift: {
                return 4;
            }
            case BitwiseAnd: 
            case BitwiseOr: {
                return 3;
            }
            case Equal: 
            case Unequal: 
            case GT: 
            case LT: 
            case GTOrEqual: 
            case LTOrEqual: 
            case Like: 
            case NotLike: 
            case StartWith: 
            case EndWith: {
                return 2;
            }
            case And: 
            case Or: {
                return 1;
            }
        }
        return 0;
    }

    public boolean isNumerics(String op) {
        return op.matches("^[\\+\\-]?(0|[1-9]\\d*|[1-9]\\d*\\.\\d+|0\\.\\d+)");
    }

    public static boolean isDatetime(String op) {
        op = op.replace("\"", "").trim();
        return op.matches("\\d{4}\\-\\d{2}\\-\\d{2}(\\s\\d{2}\\:\\d{2}\\:\\d{2})?");
    }

    public boolean needMoreOperator(char c) {
        switch (c) {
            case '!': 
            case '&': 
            case '.': 
            case '<': 
            case '=': 
            case '>': 
            case '|': {
                return true;
            }
        }
        return Character.isDigit(c);
    }

    public boolean IsCongener(char c1, char c2) {
        if (c1 == '(' || c2 == '(') {
            return false;
        }
        if (c1 == ')' || c2 == ')') {
            return false;
        }
        if (c1 == '\"' || c2 == '\"') {
            return false;
        }
        if (Character.isDigit(c1) || c1 == '.') {
            return Character.isDigit(c2) || c2 == '.';
        }
        return !Character.isDigit(c2) && c2 != '.';
    }

    public boolean IsWhileSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean IsUnitaryNode(ExpressionNodeType nodeType) {
        return nodeType == ExpressionNodeType.Plus || nodeType == ExpressionNodeType.Subtract;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ExpressionNodeType getType() {
        return this.type;
    }

    public void setType(ExpressionNodeType type) {
        this.type = type;
    }

    public int getPri() {
        return this.pri;
    }

    public void setPri(int pri) {
        this.pri = pri;
    }

    public ExpressionNode getUnitaryNode() {
        return this.unitaryNode;
    }
}

