/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.exception;

import net.lulihu.ObjectKit.StrKit;

public class RequestException
extends RuntimeException {
    private Integer responseCode;
    private String responseMessage;
    private String responseResult;

    public RequestException(String message) {
        super(message);
    }

    public RequestException(String message, Object ... values) {
        super(StrKit.format(message, values));
    }

    public RequestException(Integer responseCode, String responseMessage) {
        super(responseCode + " : " + responseMessage);
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
    }

    public RequestException(Integer responseCode, String responseMessage, String responseResult) {
        super(StrKit.format("\u9519\u8bef\u4ee3\u7801:{}, \u9519\u8bef\u6d88\u606f:{}, \u54cd\u5e94\u7ed3\u679c: {}", responseCode, responseMessage, responseResult));
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.responseResult = responseResult;
    }

    public RequestException(Throwable cause) {
        super(cause);
    }

    public RequestException(String message, Throwable cause) {
        super(message, cause);
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponseResult() {
        return this.responseResult;
    }
}

