/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.disruptorKit.oneOf;

import java.util.HashMap;
import java.util.Map;
import net.lulihu.Assert;
import net.lulihu.designPattern.chain.ResponsibilityChainHandler;
import net.lulihu.disruptorKit.oneOf.WorkHandlerConsumer;

public class WorkHandlerManage {
    private final Map<Class<?>, ResponsibilityChainHandler<?>> handlerMap = new HashMap();

    private WorkHandlerManage() {
    }

    public static WorkHandlerManage getInstance() {
        return WorkHandlerManageEnum.INSTANCE.getWorkHandlerManage();
    }

    public synchronized <T> void addWorkHandler(Class<T> name, ResponsibilityChainHandler<T> handler) {
        Assert.notNull(name, "\u5904\u7406\u7a0b\u5e8f\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull(handler, "\u5904\u7406\u7a0b\u5e8f\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue(this.handlerMap.containsKey(name), "\u5df2\u7ecf\u5b58\u5728\u6307\u5b9a\u7c7b\u578b\u7684\u5904\u7406\u7a0b\u5e8f");
        this.handlerMap.put(name, handler);
    }

    public ResponsibilityChainHandler<?> getWorkHandler(Class<?> name) {
        Assert.isTrue(!this.handlerMap.containsKey(name), "\u4e0d\u5b58\u5728\u6307\u5b9a\u7c7b\u578b\u7684\u5904\u7406\u7a0b\u5e8f");
        return this.handlerMap.get(name);
    }

    public WorkHandlerConsumer[] consumerNum(int num) {
        WorkHandlerConsumer[] consumers = new WorkHandlerConsumer[num];
        for (int i = 0; i < num; ++i) {
            consumers[i] = new WorkHandlerConsumer();
        }
        return consumers;
    }

    private static enum WorkHandlerManageEnum {
        INSTANCE;

        WorkHandlerManage workHandlerManage = new WorkHandlerManage();

        public WorkHandlerManage getWorkHandlerManage() {
            return this.workHandlerManage;
        }
    }
}

