/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.disruptorKit;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.ObjectKit.NumberKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ToolKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorManage {
    private static final Logger log = LoggerFactory.getLogger(DisruptorManage.class);
    private static final Map<String, Disruptor> disruptions = new HashMap<String, Disruptor>();
    private ThreadFactory customerExecutor = Executors.defaultThreadFactory();

    private DisruptorManage() {
    }

    public synchronized String getTemporaryName() {
        String randomString = ToolKit.getRandomString(10);
        if (disruptions.containsKey(randomString)) {
            return this.getTemporaryName();
        }
        disruptions.put(randomString, null);
        return randomString;
    }

    private static void shutdown(Iterator<Map.Entry<String, Disruptor>> iterator) {
        Map.Entry<String, Disruptor> entry = iterator.next();
        iterator.remove();
        Disruptor disruptor = entry.getValue();
        if (ObjectKit.hasNotEmpty(disruptor)) {
            log.info("\u9500\u6bc1disruption - {}", (Object)entry.getKey());
            disruptor.shutdown();
        }
    }

    public void shutdown(String name) {
        Disruptor disruptor = disruptions.remove(name);
        if (ObjectKit.hasNotEmpty(disruptor)) {
            log.info("\u9500\u6bc1disruption - {}", (Object)name);
            disruptor.shutdown();
        }
    }

    public static DisruptorManage getInstance() {
        return DisruptorEnum.INSTANCE.getDisruptorManage();
    }

    public <T> Disruptor<T> registered(String name, EventFactory<T> eventFactory, int bufferSize) {
        return this.registered(name, eventFactory, bufferSize, ProducerType.MULTI, (WaitStrategy)new YieldingWaitStrategy());
    }

    public <T> Disruptor<T> registered(String name, EventFactory<T> eventFactory, int bufferSize, ProducerType producerType, WaitStrategy waitStrategy) {
        Assert.isTrue(disruptions.get(name) != null, "\u540d\u79f0\u5df2\u5b58\u5728!");
        log.info("\u6ce8\u518cdisruption - {}", (Object)name);
        if (Integer.bitCount(bufferSize) != 1) {
            int old = bufferSize;
            bufferSize = NumberKit.getClosest2IndexGreaterThanSelf(old);
            log.warn("bufferSize\u3010{}\u3011\u4e0d\u662f2\u7684\u5e42\uff0c\u5df2\u7ecf\u81ea\u52a8\u83b7\u53d6\u6700\u8fd1\u4e14\u6700\u59272\u7684\u6307\u6570\u6b21\u5e42\u3010{}\u3011", (Object)old, (Object)bufferSize);
        }
        Disruptor disruptor = new Disruptor(eventFactory, bufferSize, this.customerExecutor, producerType, waitStrategy);
        disruptions.put(name, disruptor);
        return disruptor;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Map<String, Disruptor> map = disruptions;
            synchronized (map) {
                if (MapKit.isNotEmpty(disruptions)) {
                    log.info("\u5f00\u59cb\u9500\u6bc1 disruptor...");
                    Iterator<Map.Entry<String, Disruptor>> it = disruptions.entrySet().iterator();
                    while (it.hasNext()) {
                        DisruptorManage.shutdown(it);
                    }
                    System.out.println("disruptor \u5df2\u7ecf\u5168\u90e8\u9500\u6bc1\u5b8c\u6bd5...");
                }
            }
        }));
    }

    private static enum DisruptorEnum {
        INSTANCE;

        DisruptorManage disruptorManage = new DisruptorManage();

        public DisruptorManage getDisruptorManage() {
            return this.disruptorManage;
        }
    }
}

