/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.designPattern.chain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lulihu.designPattern.chain.AbstractHandlerResponsibilityChainResolver;
import net.lulihu.designPattern.chain.ChainDisconnectedException;
import net.lulihu.designPattern.chain.ResponsibilityChainEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponsibilityChainHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(ResponsibilityChainHandler.class);
    private List<AbstractHandlerResponsibilityChainResolver<T>> chainResolvers = new ArrayList<AbstractHandlerResponsibilityChainResolver<T>>();
    private ResponsibilityChainEventHandler<T> eventHandler;

    public ResponsibilityChainHandler<T> addHandler(AbstractHandlerResponsibilityChainResolver<T> chain) {
        this.chainResolvers.add(chain);
        return this;
    }

    public void setEventHandler(ResponsibilityChainEventHandler<T> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void handler(T data) {
        boolean beforeEvent;
        if (null != this.eventHandler && !(beforeEvent = this.eventHandler.beforeEventHandler(data))) {
            return;
        }
        AbstractHandlerResponsibilityChainResolver<T> resolver = null;
        try {
            Iterator<AbstractHandlerResponsibilityChainResolver<T>> iterator = this.chainResolvers.iterator();
            while (iterator.hasNext()) {
                AbstractHandlerResponsibilityChainResolver<T> chainResolver;
                resolver = chainResolver = iterator.next();
                data = resolver.handlerEvent(data);
            }
        }
        catch (ChainDisconnectedException chainDisconnectedException) {
        }
        catch (Exception e) {
            if (null != this.eventHandler) {
                this.eventHandler.onEventExceptionHandler(resolver != null ? resolver.getName() : null, data, e);
            } else {
                e.printStackTrace();
            }
            return;
        }
        if (null != this.eventHandler) {
            this.eventHandler.afterEventHandler(data);
        }
    }
}

