/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.designPattern.chain;

import net.lulihu.designPattern.chain.ChainDisconnectedException;
import net.lulihu.designPattern.chain.ChainEventException;
import net.lulihu.designPattern.chain.HandlerResponsibilityChainResolver;

public abstract class AbstractHandlerResponsibilityChainResolver<T>
implements HandlerResponsibilityChainResolver<T> {
    private String name;

    public AbstractHandlerResponsibilityChainResolver(String name) {
        this.name = name;
    }

    public T handlerEvent(T data) throws Exception {
        boolean support = this.support(data);
        if (support) {
            boolean proceed;
            try {
                this.resolve(data);
                data = this.after(data);
                proceed = this.proceed(data);
            }
            catch (ChainEventException e) {
                proceed = this.error(data, e);
            }
            data = this.result(data);
            if (!proceed) {
                throw new ChainDisconnectedException();
            }
        }
        return data;
    }

    public String getName() {
        return this.name;
    }
}

