/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.dateTime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.dateTime.DateTime;
import net.lulihu.dateTime.Timer;
import net.lulihu.exception.ToolBoxException;

public class DateTimeKit {
    public static final long MS = 1L;
    public static final long SECOND_MS = 1000L;
    public static final long MINUTE_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    public static final String NORM_DATETIME_MONTH_PATTERN = "yyyy-MM";
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final String NORM_DATETIME_HOUR_PATTERN = "yyyy-MM-dd HH";
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final ThreadLocal<SimpleDateFormat> NORM_DATETIME_HOUR_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(NORM_DATETIME_HOUR_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> NORM_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(NORM_DATE_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> NORM_TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(NORM_TIME_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> NORM_DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(NORM_DATETIME_PATTERN));
    public static final ThreadLocal<SimpleDateFormat> HTTP_DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(HTTP_DATETIME_PATTERN, Locale.US));

    public static String now() {
        return DateTimeKit.formatDateTime(DateTimeKit.date());
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static String today() {
        return DateTimeKit.formatDate(new DateTime());
    }

    public static int thisMonth() {
        return DateTimeKit.month(DateTimeKit.date());
    }

    public static int thisYear() {
        return DateTimeKit.year(DateTimeKit.date());
    }

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static Long getSecondTime(Date date) {
        long time = date.getTime();
        String value = String.valueOf(time);
        String sub = StrKit.sub(value, 0, value.length() - 3);
        return Long.valueOf(sub);
    }

    public static DateTime secondTimeToDate(Long secondTime) {
        return DateTimeKit.date(secondTime * 1000L);
    }

    public static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static int month(Date date) {
        return DateTimeKit.toCalendar(date).get(2) + 1;
    }

    public static int year(Date date) {
        return DateTimeKit.toCalendar(date).get(1);
    }

    public static int season(Date date) {
        return DateTimeKit.toCalendar(date).get(2) / 3 + 1;
    }

    public static String yearAndSeason(Date date) {
        return DateTimeKit.yearAndSeason(DateTimeKit.toCalendar(date));
    }

    public static LinkedHashSet<String> yearAndSeasons(Date startDate, Date endDate) {
        LinkedHashSet<String> seasons = new LinkedHashSet<String>();
        if (startDate == null || endDate == null) {
            return seasons;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (!startDate.after(endDate)) {
            seasons.add(DateTimeKit.yearAndSeason(cal));
            if (startDate.equals(endDate)) break;
            cal.add(2, 3);
            startDate = cal.getTime();
        }
        cal.setTime(endDate);
        seasons.add(DateTimeKit.yearAndSeason(cal));
        return seasons;
    }

    public static String format(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return NORM_DATETIME_FORMAT.get().format(date);
    }

    public static String formatDateHour(Date date) {
        if (null == date) {
            return null;
        }
        return NORM_DATETIME_HOUR_FORMAT.get().format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return NORM_DATE_FORMAT.get().format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return HTTP_DATETIME_FORMAT.get().format(date);
    }

    public static DateTime parse(String dateStr, SimpleDateFormat simpleDateFormat) {
        try {
            return new DateTime(simpleDateFormat.parse(dateStr));
        }
        catch (Exception e) {
            throw new ToolBoxException(StrKit.format("\u89e3\u6790 [{}] \u683c\u5f0f\u5316 [{}] \u9519\u8bef!", dateStr, simpleDateFormat.toPattern()), e);
        }
    }

    public static DateTime parse(String dateString, String format) {
        return DateTimeKit.parse(dateString, new SimpleDateFormat(format));
    }

    public static DateTime parseTimeMinutes(String dateString) {
        return DateTimeKit.parse(dateString, NORM_DATETIME_MINUTE_PATTERN);
    }

    public static DateTime parseDateTime(String dateString) {
        return DateTimeKit.parse(dateString, NORM_DATETIME_FORMAT.get());
    }

    public static DateTime parseDate(String dateString) {
        return DateTimeKit.parse(dateString, NORM_DATE_FORMAT.get());
    }

    public static DateTime parseTime(String timeString) {
        return DateTimeKit.parse(timeString, NORM_TIME_FORMAT.get());
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        dateStr = dateStr.trim();
        int length = dateStr.length();
        try {
            if (length == NORM_DATETIME_PATTERN.length()) {
                return DateTimeKit.parseDateTime(dateStr);
            }
            if (length == NORM_DATE_PATTERN.length()) {
                return DateTimeKit.parseDate(dateStr);
            }
            if (length == NORM_TIME_PATTERN.length()) {
                return DateTimeKit.parseTime(dateStr);
            }
            if (length == NORM_DATETIME_MINUTE_PATTERN.length()) {
                return DateTimeKit.parse(dateStr, NORM_DATETIME_MINUTE_PATTERN);
            }
            if (length >= NORM_DATETIME_MS_PATTERN.length() - 2) {
                return DateTimeKit.parse(dateStr, NORM_DATETIME_MS_PATTERN);
            }
        }
        catch (Exception e) {
            throw new ToolBoxException(StrKit.format("\u4f7f\u7528\u683c\u5f0f[{}]\u89e3\u6790\u9519\u8bef\uff01", dateStr));
        }
        throw new ToolBoxException(StrKit.format(" [{}]\u683c\u5f0f\u4e0d\u9002\u5408\u65e5\u671f\u6a21\u5f0f!", dateStr));
    }

    public static DateTime getBeginTimeOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new DateTime(calendar.getTime());
    }

    public static DateTime getBeginTimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new DateTime(calendar.getTime());
    }

    public static DateTime getEndTimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new DateTime(calendar.getTime());
    }

    public static DateTime yesterday() {
        return DateTimeKit.offsetDay(new DateTime(), -1);
    }

    public static DateTime lastWeek() {
        return DateTimeKit.offsetWeek(new DateTime(), -1);
    }

    public static DateTime lastMouth() {
        return DateTimeKit.offsetMonth(new DateTime(), -1);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateTimeKit.offsetDate(date, 13, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateTimeKit.offsetDate(date, 6, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateTimeKit.offsetDate(date, 3, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateTimeKit.offsetDate(date, 2, offset);
    }

    public static DateTime offsetYear(Date date, int offset) {
        return DateTimeKit.offsetDate(date, 1, offset);
    }

    public static Date offsetHour(Date date, int amount) {
        return DateTimeKit.offsetDate(date, 11, amount);
    }

    public static Date offsetMinute(Date date, int amount) {
        return DateTimeKit.offsetDate(date, 12, amount);
    }

    public static DateTime offsetDate(Date date, int calendarField, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(calendarField, offset);
        return new DateTime(cal.getTime());
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekOfYear = startCalendar.get(3);
        int endWeekOfYear = endCalendar.get(3);
        int count = endWeekOfYear - startWeekOfYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static long diffDay(Date subtrahend, Date minuend) {
        return DateTimeKit.diff(subtrahend, minuend, 86400000L);
    }

    public static long diffMinute(Date subtrahend, Date minuend) {
        return DateTimeKit.diff(subtrahend, minuend, 60000L);
    }

    public static long diffHour(Date subtrahend, Date minuend) {
        return DateTimeKit.diff(subtrahend, minuend, 3600000L);
    }

    public static long diffSecond(Date subtrahend, Date minuend) {
        return DateTimeKit.diff(subtrahend, minuend, 1000L);
    }

    public static long diff(Date subtrahend, Date minuend, long diffField) {
        long diff = minuend.getTime() - subtrahend.getTime();
        return diff / diffField;
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateTimeKit.format(date, "yyMMddHHmm"));
    }

    public static Timer timer() {
        return new Timer();
    }

    public static int ageOfNow(String birthDay) {
        return DateTimeKit.ageOfNow(DateTimeKit.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateTimeKit.age(birthDay, DateTimeKit.date());
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(StrKit.format("\u751f\u65e5\u65f6\u95f4\u5728\u6307\u5b9a\u65f6\u95f4\u4e4b\u540e {}!", DateTimeKit.formatDate(dateToCompare)));
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    private static String yearAndSeason(Calendar cal) {
        return String.valueOf(cal.get(1)) + (cal.get(2) / 3 + 1);
    }
}

