/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.dateTime;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.dateTime.DateTime;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.exception.ToolBoxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateCalculateKit {
    private static final Logger log = LoggerFactory.getLogger(DateCalculateKit.class);

    public static DateTime findBiggestTime(List<String> times) {
        String biggestTime = DateCalculateKit.findBiggestTime(times, "HH:mm");
        String format = DateTimeKit.format(DateTimeKit.date(), "HH:mm:00 yyyy-MM-dd");
        return DateTimeKit.parse(biggestTime + format.substring(5), "HH:mm:ss yyyy-MM-dd");
    }

    public static String findBiggestTime(List<String> times, String pattern) {
        if (CollectionKit.isEmpty(times) || StrKit.isEmpty(pattern)) {
            return null;
        }
        if (times.size() == 1) {
            return times.get(0);
        }
        times.sort((o1, o2) -> DateCalculateKit.compareDate(DateTimeKit.parse(o2, pattern), DateTimeKit.parse(o1, pattern)));
        return times.get(0);
    }

    public static boolean intervalJudgment(String nowTime, String beginTime, String endTime, String format) {
        return DateCalculateKit.intervalJudgment(DateTimeKit.parse(nowTime, format), DateTimeKit.parse(beginTime, format), DateTimeKit.parse(endTime, format));
    }

    public static boolean intervalJudgment(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static String dateToCron(Date date) {
        String format1 = DateTimeKit.format(date, "ss mm HH dd MM");
        String format2 = DateTimeKit.format(date, "? yyyy");
        StringBuilder builder = new StringBuilder();
        for (String str : format1.split(" ")) {
            Integer value = Integer.valueOf(str);
            builder.append(value).append(" ");
        }
        builder.append(format2);
        return builder.toString();
    }

    public static int compareDate(Date DATE1, Date DATE2) {
        return Long.compare(DATE1.getTime(), DATE2.getTime());
    }

    public static int yearDateDiff(String startDate, String endDate) {
        Calendar calBegin = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        calBegin.setTime(DateTimeKit.parse(startDate, "yyyy"));
        calEnd.setTime(DateTimeKit.parse(endDate, "yyyy"));
        return calEnd.get(1) - calBegin.get(1);
    }

    public static String[] weekStartAndEnd(Date time) {
        SimpleDateFormat dateFormat = DateTimeKit.NORM_DATE_FORMAT.get();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(1);
        cal.add(5, cal.getFirstDayOfWeek() - cal.get(7));
        String imptimeBegin = dateFormat.format(cal.getTime());
        cal.add(5, 6);
        String imptimeEnd = dateFormat.format(cal.getTime());
        return new String[]{imptimeBegin, imptimeEnd};
    }

    public static List<String> weekDays(String dateFrom, String dateEnd, String weekDays, String separator) {
        Date date;
        String[] strWeeks = weekDays.split("\\|");
        String strWeekNumber = DateCalculateKit.weekForNum(strWeeks);
        int len = strWeeks.length;
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat dateFormat = DateTimeKit.NORM_DATE_FORMAT.get();
        dateFrom = dateFormat.format(DateTimeKit.parse(dateFrom).getTime() - 86400000L);
        StringBuilder builder = new StringBuilder();
        while ((dateFrom = dateFormat.format(date = new Date(DateTimeKit.parse(dateFrom).getTime() + 86400000L))).compareTo(dateEnd) <= 0) {
            Integer weekDay = DateCalculateKit.dayForWeek(date);
            if (!strWeekNumber.contains(weekDay.toString())) continue;
            builder.append(dateFrom).append(separator);
            if (len == 0 || weekDay == 7) {
                result.add(builder.substring(0, builder.length() - separator.length()));
                builder = new StringBuilder();
                len = strWeeks.length;
            }
            --len;
        }
        return result;
    }

    public static String weekForNum(String ... strWeeks) {
        StringBuilder weekNumber = new StringBuilder();
        for (String strWeek : strWeeks) {
            weekNumber.append(DateCalculateKit.getWeekNum(strWeek));
        }
        return weekNumber.toString();
    }

    public static Integer dayForWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static Integer getWeekNum(String strWeek) {
        if ("\u661f\u671f\u65e5".equals(strWeek)) {
            return 1;
        }
        if ("\u661f\u671f\u4e00".equals(strWeek)) {
            return 2;
        }
        if ("\u661f\u671f\u4e8c".equals(strWeek)) {
            return 3;
        }
        if ("\u661f\u671f\u4e09".equals(strWeek)) {
            return 4;
        }
        if ("\u661f\u671f\u56db".equals(strWeek)) {
            return 5;
        }
        if ("\u661f\u671f\u4e94".equals(strWeek)) {
            return 6;
        }
        if ("\u661f\u671f\u516d".equals(strWeek)) {
            return 7;
        }
        throw new ToolBoxException("\u4e0d\u652f\u6301\u7684\u661f\u671f\u4e66\u5199\u65b9\u5f0f");
    }
}

