/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.dataStructure;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.exception.ToolBoxException;
import net.lulihu.functional.ConsumptionResult;

public class LRULinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final Lock readLock;
    private final Lock writeLock;

    public LRULinkedHashMap() {
        ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
        this.readLock = globalLock.readLock();
        this.writeLock = globalLock.writeLock();
    }

    @Override
    public V get(Object key) {
        return (V)this.exeReadLockMethod(() -> super.get(key));
    }

    @Override
    public V put(K key, V value) {
        return (V)this.exeWriteLockMethod(() -> super.put(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)this.exeWriteLockMethod(() -> super.remove(key));
    }

    public Map.Entry<K, V> getHead() {
        return this.exeReadLockMethod(() -> this.entrySet().iterator().next());
    }

    public Map.Entry<K, V> getTail() {
        return this.exeReadLockMethod(() -> {
            Iterator iterator = this.entrySet().iterator();
            Map.Entry tail = null;
            while (iterator.hasNext()) {
                tail = iterator.next();
            }
            return tail;
        });
    }

    public Map.Entry<K, V> getTailByReflection() {
        return this.exeReadLockMethod(() -> {
            try {
                return (Map.Entry)ReflectKit.getFieldValue((Object)this, "tail");
            }
            catch (IllegalAccessException e) {
                throw new ToolBoxException(e);
            }
        });
    }

    private <T> T exeReadLockMethod(ConsumptionResult<T> consumption) {
        try {
            this.readLock.lock();
            T t = consumption.accept();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private <T> T exeWriteLockMethod(ConsumptionResult<T> consumption) {
        try {
            this.writeLock.lock();
            T t = consumption.accept();
            return t;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

