/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.lang.reflect.Field;
import java.util.List;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.LogKit;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectKit {
    private static final Logger log = LoggerFactory.getLogger(ReflectKit.class);

    public static List<Field> getAllFieldsList(Class<?> cls) {
        return FieldUtils.getAllFieldsList(cls);
    }

    public static Object getFieldValue(Object obj, String fieldName) throws IllegalAccessException {
        Assert.notNull(obj);
        Field targetField = ReflectKit.getTargetField(obj.getClass(), fieldName);
        return FieldUtils.readField((Field)targetField, (Object)obj, (boolean)true);
    }

    public static Object getFieldValue(Object obj, Field targetField) throws IllegalAccessException {
        Assert.notNull(obj);
        Assert.notNull(targetField);
        return FieldUtils.readField((Field)targetField, (Object)obj, (boolean)true);
    }

    public static Field getTargetField(Class<?> targetClass, String fieldName) {
        if (targetClass == null || Object.class.equals(targetClass)) {
            return null;
        }
        Field field = FieldUtils.getDeclaredField(targetClass, (String)fieldName, (boolean)true);
        if (field == null) {
            field = ReflectKit.getTargetField(targetClass.getSuperclass(), fieldName);
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Assert.notNull(obj);
        Assert.notNull(fieldName);
        Assert.notNull(value);
        Field targetField = ReflectKit.getTargetField(obj.getClass(), fieldName);
        try {
            FieldUtils.writeField((Field)targetField, (Object)obj, (Object)value);
        }
        catch (IllegalAccessException e) {
            LogKit.error(log, "\u7ed9[{}]\u7684\u5c5e\u6027[{}]\u8bbe\u7f6e\u503c\u65f6\u53d1\u751f\u4f8b\u5916", obj, fieldName, e);
        }
    }

    public static void setFieldValue(Object obj, Field targetField, Object value) {
        Assert.notNull(obj);
        Assert.notNull(targetField);
        Assert.notNull(value);
        try {
            FieldUtils.writeField((Field)targetField, (Object)obj, (Object)value);
        }
        catch (IllegalAccessException e) {
            LogKit.error(log, "\u7ed9[{}]\u7684\u5c5e\u6027[{}]\u8bbe\u7f6e\u503c\u65f6\u53d1\u751f\u4f8b\u5916", obj, targetField.getName(), e);
        }
    }
}

