/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.lulihu.ObjectKit.BasicType;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.exception.ToolBoxException;

public class ObjectKit {
    private ObjectKit() {
    }

    public static Object nullToDefault(Object obj, Object defaultValue) {
        return ObjectKit.hasEmpty(obj) ? defaultValue : obj;
    }

    public static boolean equals(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static boolean hasNotEmpty(Object o) {
        return !ObjectKit.hasEmpty(o);
    }

    public static boolean hasEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.toString().trim().equals("");
        }
        if (o instanceof List) {
            return ((List)o).size() == 0;
        }
        if (o instanceof Map) {
            return ((Map)o).size() == 0;
        }
        if (o instanceof Set) {
            return ((Set)o).size() == 0;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length == 0;
        }
        if (o instanceof int[]) {
            return ((int[])o).length == 0;
        }
        if (o instanceof long[]) {
            return ((long[])o).length == 0;
        }
        return false;
    }

    public static Object primitiveDefaultValue(Class<?> clazz) {
        if (!BeanKit.isPrimitive(clazz)) {
            throw new ToolBoxException("\u7c7b\u578b\u3010{}\u3011\u4e0d\u662f\u57fa\u672c\u6570\u636e\u7c7b\u578b", clazz);
        }
        Map<Class<?>, Object> primitiveDefaultValueMap = BasicType.primitiveDefaultValueMap;
        if (primitiveDefaultValueMap.containsKey(clazz)) {
            return primitiveDefaultValueMap.get(clazz);
        }
        return BasicType.wrapperPrimitiveDefaultValueMap.get(clazz);
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (BeanKit.isPrimitive(clazz)) {
            return ObjectKit.primitiveDefaultValue(clazz);
        }
        return ClassKit.newInstanceConstructorsDefaultValue(clazz);
    }
}

