/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;

public class NumberKit {
    private NumberKit() {
    }

    public static int getClosest2IndexGreaterThanSelf(int a) {
        if (a == 1) {
            return 2;
        }
        int closest2Index = NumberKit.getClosest2Index(a);
        if (closest2Index <= a) {
            return NumberKit.getClosest2IndexGreaterThanSelf(a + 1);
        }
        return closest2Index;
    }

    public static int getClosest2Index(int a) {
        int n = a - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n + 1;
    }

    public static double keepRandomPointDouble(double var1, int n) {
        return new BigDecimal(var1).setScale(n, RoundingMode.HALF_UP).doubleValue();
    }

    public static String keepRandomPoint(Double value, int n) {
        if (value == null) {
            value = 0.0;
            return new BigDecimal(value).setScale(n, RoundingMode.HALF_UP).toString();
        }
        return new BigDecimal(value).setScale(n, RoundingMode.HALF_UP).toString();
    }

    public static String keep2Point(double value) {
        return NumberKit.keepRandomPoint(value, 2);
    }

    public static String keep1Point(double value) {
        return NumberKit.keepRandomPoint(value, 1);
    }

    public static String keepRandomPointZero(double value, int n) {
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format(Double.valueOf(NumberKit.keepRandomPoint(value, n)));
    }

    public static String keep2PointZero(double value) {
        return NumberKit.keepRandomPointZero(value, 2);
    }

    public static String percentRandomPoint(double value, int n) {
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setGroupingUsed(false);
        percent.setMaximumFractionDigits(n);
        return percent.format(value);
    }

    public static String percent2Point(double var1, double var2) {
        if (var1 == 0.0) {
            return NumberKit.percent2Point(0.0);
        }
        if (var2 == 0.0) {
            return NumberKit.percent2Point(1.0);
        }
        return NumberKit.percentRandomPoint(var1 / var2, 2);
    }

    public static String percent2Point(double value) {
        return NumberKit.percentRandomPoint(value, 2);
    }

    public static String latLngPoint(double value) {
        return NumberKit.keepRandomPoint(value, 3);
    }

    public static int rangeRandomNumber(int min, int max) {
        if (max < min) {
            throw new NumberFormatException("\u6700\u5927\u503c\u5c0f\u4e8e\u6700\u5c0f\u503c\u65e0\u6cd5\u751f\u6210\u968f\u673a\u6570...");
        }
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }
}

