/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.lang.reflect.InvocationTargetException;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.StrKit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodKit {
    private static final Logger log = LoggerFactory.getLogger(MethodKit.class);

    public static boolean existSpecifiedMethod(Class<?> aClass, String name, Class<?>[] parameterTypes) {
        return MethodUtils.getAccessibleMethod(aClass, (String)name, (Class[])parameterTypes) != null;
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod((Object)object, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeExactMethodNotException(Object object, String methodName, Object ... args) {
        try {
            args = ArrayUtils.nullToEmpty((Object[])args);
            Class[] parameterTypes = ClassUtils.toClass((Object[])args);
            return MethodKit.invokeExactMethod(object, methodName, args, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Object[] finalArgs = args;
            LogKit.error(log, "\u3010{}\u3011\u4e0d\u5b58\u5728\u65b9\u6cd5\u3010{}({} )\u3011...", () -> new Object[]{object.getClass(), methodName, StrKit.listStitchingStr(obj -> " " + obj.getClass(), finalArgs), e});
        }
        catch (IllegalAccessException e) {
            LogKit.error(log, "\u3010{}\u3011\u65b9\u6cd5\u3010{}\u3011\u65e0\u6cd5\u901a\u8fc7\u53cd\u5c04\u8bbf\u95ee...", () -> new Object[]{object.getClass(), methodName, e});
        }
        catch (InvocationTargetException e) {
            LogKit.error(log, "\u3010{}\u3011\u8fd0\u884c\u65b9\u6cd5\u3010{}\u3011\u65f6\u53d1\u751f\u4f8b\u5916...", () -> new Object[]{object.getClass(), methodName, e});
        }
        return null;
    }
}

