/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.nio.charset.Charset;
import java.util.Random;
import net.lulihu.ObjectKit.StrKit;

public class HexKit {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getRandomHexString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        int len = DIGITS_UPPER.length;
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(len);
            sb.append(DIGITS_UPPER[number]);
        }
        return sb.toString();
    }

    public static char[] encodeHex(byte[] data) {
        return HexKit.encodeHex(data, true);
    }

    public static char[] encodeHex(String str, Charset charset) {
        return HexKit.encodeHex(StrKit.getBytes(str, charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexKit.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexStr(byte[] data) {
        return HexKit.encodeHexStr(data, true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexKit.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decodeHexStr(String hexStr, Charset charset) {
        if (StrKit.isEmpty(hexStr)) {
            return hexStr;
        }
        return HexKit.decodeHexStr(hexStr.toCharArray(), charset);
    }

    public static String decodeHexStr(char[] hexData, Charset charset) {
        return StrKit.str(HexKit.decodeHex(hexData), charset);
    }

    public static byte[] decodeHex(char[] hexData) {
        int len = hexData.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("\u5b57\u7b26\u957f\u5ea6\u4e3a\u5947\u6570...");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexKit.toDigit(hexData[j], j) << 4;
            f |= HexKit.toDigit(hexData[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexKit.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("\u975e\u6cd5\u7684\u5341\u516d\u8fdb\u5236\u5b57\u7b26" + ch + "\u4e0b\u6807\u3010" + index + "\u3011");
        }
        return digit;
    }

    public static String binary2Hex(String bString) {
        if (bString == null || bString.equals("") || bString.length() % 8 != 0) {
            return null;
        }
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < bString.length(); i += 4) {
            int iTmp = 0;
            for (int j = 0; j < 4; ++j) {
                iTmp += Integer.parseInt(bString.substring(i + j, i + j + 1)) << 4 - j - 1;
            }
            tmp.append(Integer.toHexString(iTmp));
        }
        return tmp.toString();
    }

    public static String hex2Binary(String hexString) {
        if (hexString == null) {
            return null;
        }
        int length = hexString.length();
        if (length % 2 != 0) {
            return null;
        }
        StringBuilder bString = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            String tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString.substring(i, i + 1), 16));
            bString.append(tmp.substring(tmp.length() - 4));
        }
        return bString.toString();
    }

    public static String binary2Hex(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (byte b : buf) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hex2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        int len = hexStr.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

