/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.IDGeneratorKit;
import net.lulihu.exception.ToolBoxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKit {
    private static final Logger log = LoggerFactory.getLogger(FileKit.class);
    private static final int FILE_BYTE_CODE = 1024;

    public static String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String tmpFilePath(String suffix) {
        String tmpFile = FileKit.getTempPath() + "tmp_files" + File.separator + IDGeneratorKit.get() + "." + suffix;
        if (new File(tmpFile).exists()) {
            return FileKit.tmpFilePath(suffix);
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(InputStream is, File file) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int len;
            in = new BufferedInputStream(is);
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
        catch (Throwable throwable) {
            FileKit.closeInputStream(in);
            FileKit.closeOutputStream(out);
            throw throwable;
        }
        FileKit.closeInputStream(in);
        FileKit.closeOutputStream(out);
    }

    public static Path ArrayWriteFile(Iterable<? extends CharSequence> list, String filePath) throws IOException {
        return FileKit.ArrayWriteFile(list, FileKit.fileIsNullCreate(filePath));
    }

    public static Path ArrayWriteFile(Iterable<? extends CharSequence> list, Path path) throws IOException {
        return Files.write(path, list, Charset.forName("utf-8"), new OpenOption[0]);
    }

    public static boolean copy(String source, String target) throws IOException {
        return FileKit.copy(new File(source), new File(target));
    }

    public static boolean copy(File source, File target) throws IOException {
        return source.exists() && FileKit.copy(new FileInputStream(source), target);
    }

    public static boolean copy(FileInputStream inputStream, File target) throws IOException {
        FileChannel input = null;
        FileChannel output = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(target);
            input = inputStream.getChannel();
            output = outputStream.getChannel();
            output.transferFrom(input, 0L, input.size());
        }
        catch (IOException e) {
            try {
                throw new IOException("\u6587\u4ef6\u62f7\u8d1d\u9519\u8bef" + target, e);
            }
            catch (Throwable throwable) {
                FileKit.closeChannel(input);
                FileKit.closeChannel(output);
                FileKit.closeInputStream(inputStream);
                FileKit.closeOutputStream(outputStream);
                throw throwable;
            }
        }
        FileKit.closeChannel(input);
        FileKit.closeChannel(output);
        FileKit.closeInputStream(inputStream);
        FileKit.closeOutputStream(outputStream);
        return true;
    }

    public static File[] fileSort(String dirPath) {
        File file = new File(dirPath);
        String[] list = file.list();
        if (list == null || list.length == 0) {
            return null;
        }
        List<String> files = Arrays.asList(list);
        if (files.size() != 1) {
            files.sort((o1, o2) -> {
                Integer i1 = Integer.valueOf(o1.substring(0, o1.lastIndexOf(".")));
                Integer i2 = Integer.valueOf(o2.substring(0, o2.lastIndexOf(".")));
                if (i1 > i2) {
                    return 1;
                }
                if (i1 < i2) {
                    return -1;
                }
                return 0;
            });
        }
        String path = file.getPath() + File.separator;
        int n = files.size();
        File[] fs = new File[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new File(path + files.get(i));
        }
        return fs;
    }

    public static void delete(String dirPath) {
        FileKit.delete(new File(dirPath), true);
    }

    public static void delete(File dir) {
        FileKit.delete(dir, true);
    }

    public static void delete(File dir, boolean self) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            dir.delete();
            return;
        }
        String[] list = dir.list();
        if (list != null) {
            for (String element : list) {
                File child = new File(dir, element);
                FileKit.delete(child);
            }
        }
        if (self) {
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(File[] fpaths, String resultPath) throws IOException {
        if (fpaths == null || fpaths.length < 1) {
            return;
        }
        for (File fpath : fpaths) {
            if (fpath.exists() && fpath.isFile()) continue;
            throw new ToolBoxException("{}\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u666e\u901a\u6587\u4ef6...", fpath.getPath());
        }
        File resultFile = FileKit.createFile(resultPath);
        FileOutputStream fs = new FileOutputStream(resultFile, true);
        FileChannel resultFileChannel = fs.getChannel();
        FileInputStream tfs = null;
        for (File fpath : fpaths) {
            FileChannel blk = null;
            try {
                tfs = new FileInputStream(fpath);
                blk = tfs.getChannel();
                resultFileChannel.transferFrom(blk, resultFileChannel.size(), blk.size());
            }
            catch (Throwable throwable) {
                FileKit.closeInputStream(tfs);
                FileKit.closeChannel(blk);
                throw throwable;
            }
            FileKit.closeInputStream(tfs);
            FileKit.closeChannel(blk);
        }
        FileKit.closeOutputStream(fs);
        FileKit.closeChannel(resultFileChannel);
    }

    public static boolean isEmpty(String filePath) {
        return !FileKit.isNotEmpty(filePath);
    }

    public static boolean isNotEmpty(String filePath) {
        return Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    public static Path fileIsNullCreate(String indexPath) throws IOException {
        FileKit.createFile(indexPath);
        return Paths.get(indexPath, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(String filepath) throws IOException {
        String string;
        File file = new File(filepath);
        if (!file.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new FileReader(file));
            StringBuilder builder = new StringBuilder();
            while ((s = br.readLine()) != null) {
                builder.append(s);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            FileKit.closeReader(br);
            throw throwable;
        }
        FileKit.closeReader(br);
        return string;
    }

    public static File createFile(String filename) throws IOException {
        Assert.notNull(filename, "\u6587\u4ef6\u8def\u5f84\u4e0d\u53ef\u4ee5\u4e3a\u7a7a...");
        return FileKit.createFile(new File(filename));
    }

    public static File createFile(File file) throws IOException {
        if (!file.exists()) {
            FileKit.createDirectoryRecursively(file.getParent());
            file.createNewFile();
        }
        return file;
    }

    public static boolean createDirectoryRecursively(String directory) {
        String parent;
        if (directory == null) {
            return false;
        }
        File pathname = new File(directory);
        if (pathname.exists()) {
            return !pathname.isFile();
        }
        if (!pathname.isAbsolute()) {
            pathname = new File(pathname.getAbsolutePath());
        }
        if (!FileKit.createDirectoryRecursively(parent = pathname.getParent())) {
            return false;
        }
        pathname.mkdir();
        return pathname.exists();
    }

    private static void closeChannel(FileChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeOutputStream(OutputStream fos) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95edReader\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

