/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ToolBoxException;
import net.lulihu.functional.CollectionConsumption;
import net.lulihu.functional.ConsumerResult;

public class CollectionKit {
    private CollectionKit() {
    }

    public static <E, T> List<T> listToList(E[] list, ConsumerResult<E, T> consumer) {
        return CollectionKit.listToList(Arrays.asList(list), consumer);
    }

    public static <E, T> List<T> listToList(Iterable<E> list, ConsumerResult<E, T> consumer) {
        Assert.notNull(consumer, "\u8868\u8fbe\u5f0f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        ArrayList<T> result = CollectionKit.newArrayList();
        if (null == list) {
            return result;
        }
        for (E item : list) {
            result.add(consumer.accept(item));
        }
        return result;
    }

    public static <T> String join(Iterable<T> collection, String conjunction) {
        return CollectionKit.join(conjunction, collection, Object::toString);
    }

    public static <T> String join(String conjunction, Iterable<T> collection, ConsumerResult<T, String> consumption) {
        if (collection == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : collection) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(consumption.accept(item));
        }
        return sb.toString();
    }

    public static <T> String join(String conjunction, T ... array) {
        if (CollectionKit.isEmpty(array)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T item : array) {
            sb.append(conjunction).append(item);
        }
        return sb.delete(0, conjunction.length()).toString();
    }

    public static List<Map.Entry<Long, Long>> sortEntrySetToList(Set<Map.Entry<Long, Long>> set) {
        LinkedList<Map.Entry<Long, Long>> list = new LinkedList<Map.Entry<Long, Long>>(set);
        list.sort((o1, o2) -> {
            if ((Long)o1.getValue() > (Long)o2.getValue()) {
                return 1;
            }
            if ((Long)o1.getValue() < (Long)o2.getValue()) {
                return -1;
            }
            return 0;
        });
        return list;
    }

    public static <T> List<T> popPart(Stack<T> stack, int partSize) {
        if (CollectionKit.isEmpty(stack)) {
            return null;
        }
        ArrayList<T> current = new ArrayList<T>();
        int size = stack.size() < partSize ? stack.size() : partSize;
        for (int i = 0; i < size; ++i) {
            current.add(stack.pop());
        }
        return current;
    }

    public static <T> List<T> popPart(Deque<T> surplus, int partSize) {
        if (CollectionKit.isEmpty(surplus)) {
            return null;
        }
        ArrayList<T> current = new ArrayList<T>();
        int size = surplus.size() >= partSize ? partSize : surplus.size();
        for (int i = 0; i < size; ++i) {
            current.add(surplus.pop());
        }
        return current;
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <T> T[] append(T[] buffer, T newElement) {
        T[] t = CollectionKit.resize(buffer, buffer.length + 1, newElement.getClass());
        t[buffer.length] = newElement;
        return t;
    }

    public static <T> T[] resize(T[] buffer, int newSize, Class<?> componentType) {
        T[] newArray = CollectionKit.newArray(componentType, newSize);
        System.arraycopy(buffer, 0, newArray, 0, buffer.length >= newSize ? newSize : buffer.length);
        return newArray;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return CollectionKit.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (CollectionKit.isEmpty(arrays)) {
            return null;
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        T[] result = CollectionKit.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> List<T> clone(List<T> array) {
        if (array == null) {
            return CollectionKit.newArrayList();
        }
        return new ArrayList<T>(array);
    }

    public static <T> T[] clone(T[] array) {
        return array == null ? null : (Object[])array.clone();
    }

    public static int[] range(int excludedEnd) {
        return CollectionKit.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return CollectionKit.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        int size;
        if (CollectionKit.isEmpty(list)) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > (size = list.size())) {
            if (start >= size) {
                return null;
            }
            end = size;
        }
        if (start == 0 && end == size) {
            return list;
        }
        return list.subList(start, end);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollectionKit.sub(new ArrayList<T>(list), start, end);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !CollectionKit.isEmpty(array);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static <V> Collection<V> isEmpty(Collection<V> collection, CollectionConsumption<V> accept) {
        if (CollectionKit.isNotEmpty(collection)) {
            return collection;
        }
        return accept.accept();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionKit.isEmpty(collection);
    }

    public static <T, K> Map<T, K> zip(T[] keys, K[] values) {
        if (CollectionKit.isEmpty(keys) || CollectionKit.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<T, K> map = new HashMap<T, K>();
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollectionKit.zip(StrKit.split(keys, delimiter), StrKit.split(values, delimiter));
    }

    public static <T, K> Map<T, K> zip(Collection<T> keys, Collection<K> values) {
        if (CollectionKit.isEmpty(keys) || CollectionKit.isEmpty(values)) {
            return null;
        }
        ArrayList<T> keyList = new ArrayList<T>(keys);
        ArrayList<K> valueList = new ArrayList<K>(values);
        int size = Math.min(keys.size(), values.size());
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    public static <T> boolean contains(T[] array, T value) {
        Class<?> componentType = array.getClass().getComponentType();
        boolean isPrimitive = false;
        if (null != componentType) {
            isPrimitive = componentType.isPrimitive();
        }
        for (T t : array) {
            if (t == value) {
                return true;
            }
            if (isPrimitive || null == value || !value.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> wrap(T ... values) {
        if (CollectionKit.isEmpty(values)) {
            return CollectionKit.newArrayList();
        }
        return CollectionKit.newArrayList(values);
    }

    public static Object[] wrapList(List<Object> values) {
        if (CollectionKit.isEmpty(values)) {
            return new Object[0];
        }
        int size = values.size();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = values.get(i);
        }
        return result;
    }

    public static String[] wrapStr(List<String> values) {
        if (CollectionKit.isEmpty(values)) {
            return null;
        }
        int length = values.size();
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values.get(i);
        }
        return array;
    }

    public static Integer[] wrap(List<Integer> values) {
        int length = values.size();
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values.get(i);
        }
        return array;
    }

    public static Integer[] wrap(int ... values) {
        int length = values.length;
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] wrap(long ... values) {
        int length = values.length;
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] wrap(char ... values) {
        int length = values.length;
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static Byte[] wrap(byte ... values) {
        int length = values.length;
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Short[] wrap(short ... values) {
        int length = values.length;
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] wrap(float ... values) {
        int length = values.length;
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static Double[] wrap(double ... values) {
        int length = values.length;
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Boolean[] wrap(boolean ... values) {
        int length = values.length;
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean isArray(Object obj) {
        return obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (CollectionKit.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new ToolBoxException(e);
            }
        }
        return obj.toString();
    }
}

