/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import com.alibaba.fastjson.JSON;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.BasicType;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ToolBoxException;
import net.lulihu.functional.ConsumerResult;
import net.lulihu.functional.FieldValueProvider;
import net.lulihu.functional.ValueProvider;

public class BeanKit {
    private static final Map<Class<?>, Map<String, String>> beanPropertyNameMap = new ConcurrentHashMap();
    private static final Map<Class<?>, List<Field>> beanFieldMap = new ConcurrentHashMap();
    private static final Map<String, Map<String, Field>> propertyFieldMap = new ConcurrentHashMap<String, Map<String, Field>>();
    private static final Map<Class<?>, PropertyDescriptor[]> propertyDescriptorMap = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, PropertyDescriptor>> fieldNamePropertyDescriptorMap = new ConcurrentHashMap();

    private BeanKit() {
    }

    public static Map<String, String> getBeanPropertyName(Class<?> clazz) {
        return beanPropertyNameMap.computeIfAbsent(clazz, k -> {
            List<Field> fields = BeanKit.getBeanField(k);
            if (CollectionKit.isEmpty(fields)) {
                return new HashMap();
            }
            HashMap<String, String> result = new HashMap<String, String>(fields.size() * 2);
            for (Field field : fields) {
                String name = field.getName();
                result.put(StrKit.toCamelCase(name), name);
            }
            HashMap resultTmp = new HashMap(fields.size());
            for (Map.Entry next : result.entrySet()) {
                resultTmp.put(StrKit.toUnderlineCase((String)next.getKey()), next.getValue());
            }
            result.putAll(resultTmp);
            return result;
        });
    }

    public static List<Field> getBeanField(Class<?> clazz) {
        Assert.notNull(clazz, "Class\u4e0d\u80fd\u4e3a\u7a7a...");
        return beanFieldMap.computeIfAbsent(clazz, beanClass -> {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class currentClass = beanClass; currentClass != null && !Object.class.equals((Object)currentClass); currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    field.setAccessible(true);
                    propertyFieldMap.computeIfAbsent(beanClass.getName(), k -> new ConcurrentHashMap()).putIfAbsent(field.getName(), field);
                    fieldList.add(field);
                }
            }
            return fieldList;
        });
    }

    public static Field getPropertyField(Class<?> clazz, String fieldName) {
        return propertyFieldMap.computeIfAbsent(clazz.getName(), k -> new ConcurrentHashMap()).computeIfAbsent(fieldName, k -> ReflectKit.getTargetField(clazz, fieldName));
    }

    public static boolean isBean(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return String.class.equals(clazz) || BasicType.wrapperPrimitiveMap.containsKey(clazz) || BasicType.primitiveWrapperMap.containsKey(clazz);
    }

    public static boolean isNumberPrimitive(Class<?> clazz) {
        return BasicType.numberWrapperPrimitiveMap.containsKey(clazz) || BasicType.numberPrimitiveWrapperMap.containsKey(clazz);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        return propertyDescriptorMap.computeIfAbsent(clazz, k -> {
            try {
                return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new ToolBoxException(e);
            }
        });
    }

    public static Map<String, PropertyDescriptor> getFieldNamePropertyDescriptorMap(Class<?> clazz) {
        return fieldNamePropertyDescriptorMap.computeIfAbsent(clazz, k -> {
            PropertyDescriptor[] propertyDescriptors = BeanKit.getPropertyDescriptors(k);
            LinkedHashMap<String, PropertyDescriptor> map = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                map.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            return map;
        });
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) {
        return BeanKit.getFieldNamePropertyDescriptorMap(clazz).get(fieldName);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass) {
        return BeanKit.fillBeanWithMap(map, ClassKit.newInstance(beanClass));
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass) {
        return BeanKit.fillBeanWithMapIgnoreCase(map, ClassKit.newInstance(beanClass));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean) {
        return BeanKit.fillBean(bean, (name, clazz) -> map.get(name));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase) {
        if (isToCamelCase) {
            HashMap map2 = new HashMap();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String keyStr = (String)key;
                    map2.put(StrKit.toCamelCase(keyStr), entry.getValue());
                    continue;
                }
                map2.put((String)key, entry.getValue());
            }
            return BeanKit.fillBeanWithMap(map2, bean);
        }
        return BeanKit.fillBeanWithMap(map, bean);
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean) {
        HashMap map2 = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                String keyStr = (String)key;
                map2.put(keyStr.toLowerCase(), entry.getValue());
                continue;
            }
            map2.put((String)key, entry.getValue());
        }
        return BeanKit.fillBean(bean, (name, clazz) -> map2.get(name.toLowerCase()));
    }

    public static <T> T requestParamToBean(ServletRequest request, Class<T> beanClass) {
        return BeanKit.fillBeanWithRequestParam(request, ClassKit.newInstance(beanClass));
    }

    public static <T> T fillBeanWithRequestParam(ServletRequest request, T bean) {
        String beanName = StrKit.lowerFirst(bean.getClass().getSimpleName());
        return BeanKit.fillBean(bean, (name, clazz) -> {
            String value = request.getParameter(name);
            if (StrKit.isEmpty(value) && StrKit.isEmpty(value = request.getParameter(beanName + "." + name))) {
                value = null;
            }
            return value;
        });
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider valueProvider) {
        return BeanKit.fillBean(ClassKit.newInstance(beanClass), valueProvider);
    }

    public static <T> T fillBean(T bean, ValueProvider valueProvider) {
        if (null == valueProvider) {
            return bean;
        }
        List<Field> fields = BeanKit.getBeanField(bean.getClass());
        for (Field field : fields) {
            String fieldName = field.getName();
            Object value = valueProvider.value(fieldName, field.getType());
            if (ObjectKit.hasEmpty(value)) continue;
            ReflectKit.setFieldValue(bean, fieldName, value);
        }
        return bean;
    }

    public static <T> T fillBeanField(T bean, FieldValueProvider valueProvider) {
        if (null == valueProvider) {
            return bean;
        }
        List<Field> fields = BeanKit.getBeanField(bean.getClass());
        for (Field field : fields) {
            String fieldName = field.getName();
            Object value = valueProvider.value(field);
            if (ObjectKit.hasEmpty(value)) continue;
            ReflectKit.setFieldValue(bean, fieldName, value);
        }
        return bean;
    }

    public static <T> Map<String, Object> beanToMap(T bean, Map<String, Object> map) {
        return BeanKit.beanToMap(bean, map, false);
    }

    public static <T> Map<String, String> beanValueAsJsonToMap(Map<String, String> map, T bean) {
        return BeanKit.beanToMap(bean, map, false, value -> {
            if (BeanKit.isPrimitive(value.getClass())) {
                return value.toString();
            }
            return JSON.toJSONString((Object)value);
        });
    }

    public static <T> List<Map<String, Object>> listToMapList(List<T> bean, Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (T t : bean) {
            maps.add(BeanKit.beanToMap(bean, map, false));
        }
        return maps;
    }

    public static <T> Map<String, Object> beanToMap(T bean, Map<String, Object> map, boolean isToUnderlineCase) {
        return BeanKit.beanToMap(bean, map, isToUnderlineCase, value -> value);
    }

    public static <T, D> Map<String, D> beanToMap(T bean, Map<String, D> map, boolean isToUnderlineCase, ConsumerResult<Object, D> consumerResult) {
        if (bean == null) {
            return null;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanKit.getPropertyDescriptors(bean.getClass())) {
                Method getter;
                Object value;
                String key = property.getName();
                if (key.equals("class") || null == (value = (getter = property.getReadMethod()).invoke(bean, new Object[0]))) continue;
                map.put(isToUnderlineCase ? StrKit.toUnderlineCase(key) : key, consumerResult.accept(value));
            }
        }
        catch (Exception e) {
            throw new ToolBoxException(e);
        }
        return map;
    }

    public static void copyProperties(Object source, Object target) {
        BeanKit.copyProperties(source, target, CopyOptions.create());
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanKit.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        Class actualEditable = target.getClass();
        if (copyOptions.editable != null) {
            if (!copyOptions.editable.isInstance(target)) {
                throw new IllegalArgumentException(StrKit.format("\u76ee\u6807\u7c7b[{}]\u65e0\u6cd5\u5206\u914d\u7ed9\u53ef\u7f16\u8f91\u7c7b[{}]", target.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        Map<String, PropertyDescriptor> sourcePdMap = BeanKit.getFieldNamePropertyDescriptorMap(source.getClass());
        PropertyDescriptor[] targetPds = BeanKit.getPropertyDescriptors(actualEditable);
        HashSet<String> ignoreSet = copyOptions.ignoreProperties != null ? CollectionKit.newHashSet(copyOptions.ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreSet != null && ignoreSet.contains(targetPd.getName()) || (sourcePd = sourcePdMap.get(targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassKit.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object value = ClassKit.setAccessible(readMethod).invoke(source, new Object[0]);
                if (null == value && copyOptions.isIgnoreNullValue) continue;
                ClassKit.setAccessible(writeMethod).invoke(target, value);
            }
            catch (Throwable ex) {
                throw new ToolBoxException(ex, "\u5c06\u5c5e\u6027[{}]\u590d\u5236\u5230[{}]\u9519\u8bef: {}", sourcePd.getName(), targetPd.getName(), ex.getMessage());
            }
        }
    }

    public static class CopyOptions {
        private Class<?> editable;
        private boolean isIgnoreNullValue;
        private String[] ignoreProperties;

        public static CopyOptions create() {
            return new CopyOptions();
        }

        public static CopyOptions create(Class<?> editable, boolean isIgnoreNullValue, String ... ignoreProperties) {
            return new CopyOptions(editable, isIgnoreNullValue, ignoreProperties);
        }

        public CopyOptions() {
        }

        public CopyOptions(Class<?> editable, boolean isIgnoreNullValue, String ... ignoreProperties) {
            this.editable = editable;
            this.isIgnoreNullValue = isIgnoreNullValue;
            this.ignoreProperties = ignoreProperties;
        }

        public CopyOptions setEditable(Class<?> editable) {
            this.editable = editable;
            return this;
        }

        public CopyOptions setIgnoreNullValue(boolean isIgnoreNullValue) {
            this.isIgnoreNullValue = isIgnoreNullValue;
            return this;
        }

        public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
            this.ignoreProperties = ignoreProperties;
            return this;
        }
    }
}

