/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu;

import java.util.ArrayList;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.AbstractException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assert {
    private static final Logger log = LoggerFactory.getLogger(Assert.class);

    public static void isTrue(boolean boo, AbstractException exceptionEnum) {
        if (boo) {
            throw new IllegalArgumentException(exceptionEnum.getMessage());
        }
    }

    public static void isTrueExcep(boolean boo, RuntimeException e) {
        if (boo) {
            throw e;
        }
    }

    public static void isTrue(boolean boo, String message) {
        if (boo) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T requireNonNull(T object) {
        Assert.notNull(object, new NullPointerException());
        return object;
    }

    public static <T> T requireNonNull(T object, String message) {
        Assert.notNull(object, new NullPointerException(message));
        return object;
    }

    public static void notNull(Object object, String message) {
        Assert.notNull(object, new NullPointerException(message));
    }

    public static void notNull(Object object, String message, Object ... params) {
        Assert.notNull(object, new NullPointerException(StrKit.format(message, params)));
    }

    public static void notNull(Object object) {
        Assert.notNull(object, new NullPointerException());
    }

    public static void notNull(Object object, RuntimeException e) {
        Assert.isTrueExcep(object == null, e);
    }

    public static void notEmpty(Object object, String message) {
        Assert.notEmpty(object, new IllegalArgumentException(message));
    }

    public static void notEmpty(Object object, RuntimeException e) {
        Assert.isTrueExcep(ObjectKit.hasEmpty(object), e);
    }

    public static void notNull(String str, String message) {
        Assert.isTrue(StrKit.isEmpty(str), message);
    }

    public static void notEmpty(Object[] array, String message) {
        Assert.isTrue(CollectionKit.isEmpty(array), message);
    }

    public static void foundClass(String fullClassName, String message) {
        try {
            Class.forName(fullClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    public static void noSpecialSymbols(String str, String message, String ... symbols) {
        ArrayList<String> err = new ArrayList<String>();
        for (String sym : symbols) {
            if (!str.contains(sym)) continue;
            err.add(sym);
        }
        if (err.size() != 0) {
            throw new IllegalArgumentException(message.replace("{}", "\u3010" + String.join((CharSequence)",", err) + "\u3011"));
        }
    }
}

