package net.lulihu.promise;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 异步执行工具
 */
public class Async {

    private final static ExecutorService defaultExecutor;

    static {
        int cores = Runtime.getRuntime().availableProcessors();
        defaultExecutor = Executors.newFixedThreadPool(cores);
    }

    /**
     * 关闭线程池
     */
    public static void shutdown() {
        defaultExecutor.shutdownNow();
    }

    /**
     * 提交执行
     * 使用默认先线程池
     *
     * @param callable 任务
     * @param <V>      泛型类型
     * @return {@linkplain Promise}
     */
    public static <V> Promise<V> submit(Callable<V> callable) {
        return submit(callable, defaultExecutor);
    }

    /**
     * 提交执行
     *
     * @param callable        任务
     * @param executorService 任务执行线程池
     * @param <V>             泛型类型
     * @return {@linkplain Promise}
     */
    public static <V> Promise<V> submit(Callable<V> callable, ExecutorService executorService) {
        final Promise<V> promise = new Promise<>();

        Callable<V> smarterCallable = () -> {
            try {
                V result = callable.call();
                promise.invoke(result);
                return result;
            } catch (Throwable e) {
                promise.invokeWithException(e);
                return null;
            }
        };

        executorService.submit(smarterCallable);
        return promise;
    }
}
