package net.lulihu.jdbc.orm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * Sql语句执行程序
 */
public interface SqlStatementExecutor {


    /**
     * 执行保存语句并且返回主键id
     *
     * @param connection 数据库连接
     * @param sql        sql语句
     * @param params     占位符替换参数
     * @return 返回主键id
     */
    Integer executeInsertAndReturnId(Connection connection, String sql, Object... params) throws SQLException;

    /**
     * 执行修改语句
     *
     * @param connection 数据库连接
     * @param sql        sql语句
     * @param params     占位符替换参数
     * @return 返回影响行数
     */
    int executeUpdate(Connection connection, String sql, Object... params) throws SQLException;

    /**
     * 执行查询语句返回一条数据
     *
     * @param connection  数据库连接
     * @param resultClass 返回值类型
     * @param sql         sql语句
     * @param params      占位符替换参数
     * @param <T>         泛型
     * @return 查询结果
     */
    <T> T executeQueryOne(Connection connection, Class<T> resultClass, String sql, Object... params) throws SQLException;

    /**
     * 执行查询语句返回多条数据
     *
     * @param connection      数据库连接
     * @param resultListClass 集合返回值类型
     * @param resultClass     返回值类型
     * @param sql             sql语句
     * @param params          占位符替换参数
     * @param <T>             泛型
     * @return 查询结果
     */
    <T> List<T> executeQueryList(Connection connection, Class<? extends List> resultListClass, Class<T> resultClass, String sql, Object... params) throws SQLException;

}
