package net.lulihu.http.builder;

import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import okio.Buffer;

import java.io.IOException;

/**
 * 请求日志拦截器
 */
@Slf4j
public class RequestLogInterceptor implements Interceptor {

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        log.debug("请求地址: {}", request.url());
        log.debug("请求方式: {}", request.method());
        log.debug("请求头部信息: {}", request.headers());

        String param;
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            param = "";
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo(buffer);
            param = buffer.readUtf8();

            // 将参数写回请求体
            MediaType mediaType = requestBody.contentType();
            RequestBody body = RequestBody.create(mediaType, param);
            request = request.newBuilder().method(request.method(), body).build();
        }
        log.debug("请求参数: {}", param);

        // 执行请求
        Response response = chain.proceed(request);

        long sent = response.sentRequestAtMillis();
        long received = response.receivedResponseAtMillis();
        log.debug("请求耗时: {}/ms", received - sent);
        return response;
    }

}
