package net.lulihu.http.builder;

import net.lulihu.ObjectKit.StrKit;

/**
 * Http 请求出现例外
 */
public class HttpRequestException extends RuntimeException {


    public HttpRequestException(Integer responseCode, String responseMessage, String responseResult) {
        super(StrKit.format("错误代码:{}, 错误消息:{}, 响应结果: {}",
                responseCode, responseMessage, responseResult));
    }

    public HttpRequestException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public HttpRequestException(Throwable throwable, String message, Object... param) {
        this(StrKit.format(message, param), throwable);
    }

}
