/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.impl;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.mule.tccTransaction.enums.MuleActionEnum;
import net.lulihu.mule.tccTransaction.enums.MuleRoleEnum;
import net.lulihu.mule.tccTransaction.exception.NotFindSuitableObjectException;
import net.lulihu.mule.tccTransaction.kit.OrderExecuteLockThreadLocalKit;
import net.lulihu.mule.tccTransaction.kit.ServletRequestLocalKit;
import net.lulihu.mule.tccTransaction.kit.TransactionContextLocalKit;
import net.lulihu.mule.tccTransaction.kit.TransactionKit;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.TransactionHandlerService;
import net.lulihu.mule.tccTransaction.service.TransactionMethodProxyService;
import net.lulihu.mule.tccTransaction.service.factory.TransactionComponentFactoryService;
import net.lulihu.mule.tccTransaction.service.factory.TransactionFactoryManageEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionMethodProxyServiceImpl
implements TransactionMethodProxyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionMethodProxyServiceImpl.class);
    private final TransactionComponentFactoryService transactionFactoryHandlerService = TransactionFactoryManageEnum.INSTANCE.getTransactionFactoryManage();

    @Override
    public TransactionHandlerService beforeTransactionHandler() throws NotFindSuitableObjectException {
        OrderExecuteLockThreadLocalKit.set();
        TransactionContext transactionContext = this.transactionContext();
        TransactionContextLocalKit.set(transactionContext);
        TransactionHandlerService handler = this.transactionFactoryHandlerService.electionTransactionHandler(transactionContext);
        LogKit.debug((Logger)log, (String)"\u4e8b\u52a1\u4e0a\u4e0b\u6587:{} - \u9009\u4e3e\u4e8b\u52a1\u5904\u7406\u5668:{}", (Object)transactionContext, handler.getClass());
        return handler;
    }

    @Override
    public boolean before(TransactionHandlerService handlerService, Class<?> beanClass, Method method, Object[] args) {
        return handlerService.beforeHandler(beanClass, method, args);
    }

    @Override
    public Object result(TransactionHandlerService handlerService, Object result) {
        return handlerService.resultHandler(result);
    }

    @Override
    public Object exception(TransactionHandlerService handlerService, Throwable throwable) throws Throwable {
        return handlerService.exceptionHandler(throwable);
    }

    @Override
    public void after(TransactionHandlerService handlerService) {
        handlerService.afterHandler();
    }

    public TransactionContext transactionContext() {
        TransactionContext transactionContext = TransactionContextLocalKit.get();
        if (null != transactionContext) {
            if (transactionContext.getRole() == MuleRoleEnum.START.getCode()) {
                transactionContext.setRole(MuleRoleEnum.START_LOCAL.getCode());
            } else if (transactionContext.getRole() == MuleRoleEnum.RPC.getCode()) {
                transactionContext.setRole(MuleRoleEnum.RPC_LOCAL.getCode());
            }
        } else {
            String context;
            HttpServletRequest servletRequest = ServletRequestLocalKit.get();
            String string = context = servletRequest == null ? null : servletRequest.getHeader("MULE_TCC_TRANSACTION_CONTEXT");
            if (StrKit.notBlank((String)context)) {
                transactionContext = (TransactionContext)JSON.parseObject((String)context, TransactionContext.class);
                transactionContext.setRole(MuleRoleEnum.RPC.getCode());
            } else {
                transactionContext = TransactionKit.buildMuleTransactionContext(MuleActionEnum.TRYING, MuleRoleEnum.START);
            }
        }
        return transactionContext;
    }
}

