/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.handler;

import java.lang.reflect.Method;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.ThreadLocalKit;
import net.lulihu.mule.tccTransaction.enums.MuleRoleEnum;
import net.lulihu.mule.tccTransaction.kit.ServletRequestLocalKit;
import net.lulihu.mule.tccTransaction.kit.StarterTransactionExecutorEventLocalKit;
import net.lulihu.mule.tccTransaction.kit.StarterTransactionHandlerKit;
import net.lulihu.mule.tccTransaction.kit.TransactionContextLocalKit;
import net.lulihu.mule.tccTransaction.kit.TransactionKit;
import net.lulihu.mule.tccTransaction.kit.TransactionLogLocalKit;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.handler.AbstractTransactionHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarterTransactionHandler
extends AbstractTransactionHandlerService {
    private static final Logger log = LoggerFactory.getLogger(StarterTransactionHandler.class);

    @Override
    public boolean support(TransactionContext transactionContext) {
        return MuleRoleEnum.START.getCode() == transactionContext.getRole();
    }

    @Override
    public boolean beforeHandler(Class<?> beanClass, Method method, Object[] args) {
        LogKit.debug((Logger)log, (String)"\u3010{}\u3011\u4ee3\u7406\u65b9\u6cd5\u3010{}\u3011\u4e8b\u52a1\u542f\u52a8...", beanClass, (Object)method.getName());
        TransactionContext context = TransactionContextLocalKit.get();
        MuleTransaction muleTransaction = TransactionKit.buildMuleTransaction(context.getTransId(), MuleRoleEnum.START, beanClass, method, args);
        TransactionLogLocalKit.set(muleTransaction);
        this.transactionExecutorService.saveTransaction(muleTransaction);
        return true;
    }

    @Override
    public Object resultHandler(Object result) {
        if (ServletRequestLocalKit.notRequest()) {
            StarterTransactionHandlerKit.exeConfirm(this.transactionExecutorService);
        }
        return result;
    }

    @Override
    public Object exceptionHandler(Throwable throwable) throws Throwable {
        if (ServletRequestLocalKit.notRequest()) {
            StarterTransactionHandlerKit.exeCancel(this.transactionExecutorService);
        }
        throw throwable;
    }

    @Override
    public void afterHandler() {
        if (ServletRequestLocalKit.notRequest()) {
            ThreadLocalKit.clearAll();
        } else {
            StarterTransactionExecutorEventLocalKit.set(this.transactionExecutorService);
        }
    }

    @Override
    public String componentName() {
        return "\u4e8b\u52a1\u53d1\u8d77\u8005\u5904\u7406\u5668";
    }
}

