/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.coordinator.db;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.mule.tccTransaction.MuleTccConfig;
import net.lulihu.mule.tccTransaction.MuleTccShutdownManage;
import net.lulihu.mule.tccTransaction.exception.MuleTccException;
import net.lulihu.mule.tccTransaction.service.MuleTccShutdownService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataSourceManage
implements MuleTccShutdownService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceManage.class);
    private DataSource dataSource;

    DataSourceManage() {
    }

    void setDataSource(MuleTccConfig.DbConfig config) {
        LogKit.debug((Logger)log, (String)"\u5f00\u59cb\u52a0\u8f7dMule Tcc\u5185\u90e8\u6570\u636e\u6e90...");
        try {
            this.dataSource = config.getDataSource() != null ? config.getDataSource() : this.initDataSource(config);
            LogKit.debug((Logger)log, (String)"Mule Tcc\u5185\u90e8\u6570\u636e\u6e90\u52a0\u8f7d\u6210\u529f...");
        }
        catch (Exception e) {
            throw new MuleTccException("Mule Tcc\u5185\u90e8\u6570\u636e\u6e90\u52a0\u8f7d\u65f6\u53d1\u751f\u4f8b\u5916", e);
        }
        MuleTccShutdownManage.getInstance().addComponents(this);
    }

    Connection getConnection() throws SQLException {
        Assert.notNull((Object)this.dataSource, (String)"\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u8fde\u63a5...");
        return this.dataSource.getConnection();
    }

    private DataSource initDataSource(MuleTccConfig.DbConfig dbConfig) {
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setPoolName("MuleTccDbPool");
        hikariDataSource.setJdbcUrl(dbConfig.getUrl());
        hikariDataSource.setDriverClassName(dbConfig.getDriverClassName());
        hikariDataSource.setUsername(dbConfig.getUsername());
        hikariDataSource.setPassword(dbConfig.getPassword());
        hikariDataSource.setMaximumPoolSize(dbConfig.getMaxActive());
        hikariDataSource.setMinimumIdle(dbConfig.getMinIdle());
        hikariDataSource.setConnectionTimeout(dbConfig.getConnectionTimeout());
        hikariDataSource.setIdleTimeout(dbConfig.getIdleTimeout());
        hikariDataSource.setMaxLifetime(dbConfig.getMaxLifetime());
        hikariDataSource.setConnectionTestQuery(dbConfig.getConnectionTestQuery());
        if (MapKit.isNotEmpty(dbConfig.getDataSourcePropertyMap())) {
            dbConfig.getDataSourcePropertyMap().forEach((arg_0, arg_1) -> ((HikariDataSource)hikariDataSource).addDataSourceProperty(arg_0, arg_1));
        }
        return hikariDataSource;
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void shutdown() {
        LogKit.debug((Logger)log, (String)"\u5f00\u59cb\u5173\u95ed\u5185\u90e8\u6570\u636e\u6e90...");
        if (this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
        LogKit.debug((Logger)log, (String)"\u5185\u90e8\u6570\u636e\u6e90\u5173\u95ed\u6210\u529f...");
    }
}

