/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.kit;

import java.util.Arrays;
import net.lulihu.mule.tccTransaction.enums.DbTypeEnum;
import net.lulihu.mule.tccTransaction.exception.MuleTccException;

public class TableSqlKit {
    public static String[] getCreateTableSql(String driverClassName, String tableName) {
        return TableSqlKit.getCreateTableSql(DbTypeEnum.getDbTypeByDriverClassName(driverClassName), tableName);
    }

    public static String[] getCreateTableSql(DbTypeEnum dbTypeEnum, String tableName) {
        if (dbTypeEnum.equals((Object)DbTypeEnum.MYSQL)) {
            return new String[]{TableSqlKit.transactionLogMysql(tableName), TableSqlKit.transactionCompensationsMysql(tableName)};
        }
        throw new MuleTccException("\u4e0d\u652f\u6301\u7684DB\u7c7b\u578b\uff0c\u76ee\u524d\u53ea\u652f\u6301{}", Arrays.asList(DbTypeEnum.values()));
    }

    private static String transactionLogMysql(String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (  `trans_id` varchar(64) NOT NULL COMMENT '\u4e8b\u52a1id',  `status` tinyint NOT NULL COMMENT '\u4e8b\u52a1\u6267\u884c\u72b6\u6001',  `role` tinyint NOT NULL COMMENT '\u4e8b\u52a1\u6267\u884c\u89d2\u8272',  `target_class` varchar(256) COMMENT '\u6267\u884c\u76ee\u6807\u5168\u7c7b\u540d',  `target_method` varchar(128) COMMENT '\u6267\u884c\u76ee\u6807\u65b9\u6cd5\u540d\u79f0',  `participants` longblob COMMENT '\u4e8b\u52a1\u53c2\u4e0e\u8005',  `version` tinyint NOT NULL COMMENT '\u4e8b\u52a1\u8865\u507f\u65f6\u4f7f\u7528\u7684\u4e50\u89c2\u9501\u7248\u672c\u53f7',  `create_time` varchar(64) NOT NULL COMMENT '\u4e8b\u52a1\u8bb0\u5f55\u521b\u5efa\u65f6\u95f4 yyyy-MM-dd HH:mm:ss.SSS',  `last_time` varchar(64) NOT NULL COMMENT '\u4e8b\u52a1\u8bb0\u5f55\u6700\u540e\u4fee\u6539\u65f6\u95f4 yyyy-MM-dd HH:mm:ss.SSS',  PRIMARY KEY (`trans_id`)) COMMENT = '\u670d\u52a1\u3010" + tableName + "\u3011\u7684\u4e8b\u52a1\u8bb0\u5f55\u8868'";
    }

    private static String transactionCompensationsMysql(String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "_compensations" + "`(  `trans_id` varchar(64)  NOT NULL COMMENT '\u4e8b\u52a1id',  `status` tinyint(4) NOT NULL COMMENT '\u4e8b\u52a1\u8865\u507f\u72b6\u6001',  `create_time` varchar(64) NOT NULL COMMENT '\u4e8b\u52a1\u8865\u507f\u8bb0\u5f55\u521b\u5efa\u65f6\u95f4 yyyy-MM-dd HH:mm:ss.SSS',  PRIMARY KEY (`trans_id`)) COMMENT = '\u670d\u52a1\u3010" + tableName + "\u3011\u7684\u4e8b\u52a1\u8865\u507f\u8bb0\u5f55\u8868'";
    }
}

