/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.kit;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.mule.tccTransaction.exception.RepositoryMapperException;
import net.lulihu.mule.tccTransaction.serializer.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultSetKit {
    private static final Logger log = LoggerFactory.getLogger(QueryResultSetKit.class);

    public static Object putResultSet(ObjectSerializer serializer, ResultSet resultSet, Class<?> resultClass) throws Exception {
        int resultType;
        if (BeanKit.isPrimitive(resultClass)) {
            resultType = 1;
        } else if (BeanKit.isBean(resultClass)) {
            resultType = 2;
        } else {
            throw new RepositoryMapperException("\u9519\u8bef\u7684\u8fd4\u56de\u503c\u7c7b\u578b\u3010{}\u3011", resultClass);
        }
        return QueryResultSetKit.putResultSetToArray(resultType, serializer, resultSet, resultClass);
    }

    private static Object putResultSetToArray(int resultType, ObjectSerializer serializer, ResultSet resultSet, Class<?> resultClass) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        ResultSetMetaData data = resultSet.getMetaData();
        while (resultSet.next()) {
            Object value = resultType == 1 ? resultSet.getObject(1) : QueryResultSetKit.putResultSet(serializer, resultClass, resultSet, data);
            result.add(value);
        }
        return result;
    }

    private static Object putResultSet(ObjectSerializer serializer, Class<?> resultClass, ResultSet resultSet, ResultSetMetaData data) throws Exception {
        int count = data.getColumnCount();
        Object result = ClassKit.newInstance(resultClass);
        Map propertyName = BeanKit.getBeanPropertyName(resultClass);
        for (int i = 1; i <= count; ++i) {
            String columnName = data.getColumnLabel(i);
            Object value = resultSet.getObject(columnName);
            if (value == null || !propertyName.containsKey(columnName)) continue;
            String fieldName = (String)propertyName.get(columnName);
            if (value instanceof byte[]) {
                Field targetField = ReflectKit.getTargetField(resultClass, (String)fieldName);
                Class<Object> type = targetField.getType();
                if (!value.getClass().equals(type)) {
                    if (type.equals(List.class)) {
                        type = ArrayList.class;
                    } else if (type.equals(Map.class)) {
                        type = HashMap.class;
                    } else if (type.equals(Set.class)) {
                        type = HashSet.class;
                    }
                    value = serializer.deSerialize((byte[])value, type);
                }
            }
            ReflectKit.setFieldValue((Object)result, (String)fieldName, (Object)value);
        }
        return result;
    }
}

