/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.kit;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.MethodKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.functional.Consumption;
import net.lulihu.mule.tccTransaction.enums.MuleActionEnum;
import net.lulihu.mule.tccTransaction.exception.ParticipantMethodExeFailureException;
import net.lulihu.mule.tccTransaction.kit.ObjectContextHolder;
import net.lulihu.mule.tccTransaction.kit.TransactionContextLocalKit;
import net.lulihu.mule.tccTransaction.model.MuleParticipant;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantKit {
    private static final Logger log = LoggerFactory.getLogger(ParticipantKit.class);

    public static void exeParticipantMethod(TransactionCoordinatorService transactionCoordinatorService, boolean status, Integer retryMax, MuleTransaction muleTransaction) {
        transactionCoordinatorService.updateStatus(muleTransaction, null);
        List<MuleParticipant> participants = muleTransaction.getParticipants();
        ParticipantKit.exeParticipantMethod(status, retryMax, (Integer)1, participants);
        if (CollectionKit.isEmpty(participants)) {
            transactionCoordinatorService.delete(muleTransaction, null);
        } else {
            transactionCoordinatorService.updateParticipant(muleTransaction, null);
        }
    }

    public static void exeParticipantMethod(boolean status, int retryNum, List<MuleParticipant> muleParticipants) throws ParticipantMethodExeFailureException {
        ParticipantKit.exeParticipantMethod(status, null, (Integer)retryNum, muleParticipants);
    }

    public static void exeParticipantMethod(boolean status, Integer retryMax, Integer retryNum, List<MuleParticipant> muleParticipants) throws ParticipantMethodExeFailureException {
        Assert.notNull((Object)retryNum, (String)"\u91cd\u8bd5\u6b21\u6570\u4e0d\u53ef\u4ee5\u4e3a\u7a7a...");
        if (CollectionKit.isEmpty(muleParticipants)) {
            return;
        }
        for (int i = muleParticipants.size() - 1; i >= 0; --i) {
            MuleParticipant muleParticipant = muleParticipants.get(i);
            Integer retries = muleParticipant.getRetries();
            if (retryMax != null && retries >= retryMax) continue;
            if (retryMax != null && retries + retryNum > retryMax) {
                int oldRetryNum = retryNum;
                retryNum = retryMax - retries;
                LogKit.warn((Logger)log, (String)"\u5f53\u524d\u4ee5\u53ca\u91cd\u8bd5\u6b21\u6570\u4e3a{}\uff0c\u672c\u6b21\u8bbe\u5b9a\u91cd\u590d\u6b21\u6570\u4e3a{}\uff0c\u4ee5\u53ca\u8d85\u8fc7\u6700\u5927\u91cd\u590d\u6b21\u6570{}\uff0c\u81ea\u52a8\u964d\u7ea7\u91cd\u8bd5\u6b21\u6570\u4e3a{}", (Object[])new Object[]{retries, oldRetryNum, retryMax, retryNum});
            }
            Boolean compensation = muleParticipant.getParticipateCompensation();
            TransactionContext context = TransactionContextLocalKit.get();
            if (!compensation.booleanValue()) {
                context.setAction(MuleActionEnum.DELETE.getCode());
            } else {
                context.setAction(status ? MuleActionEnum.CONFIRMING.getCode() : MuleActionEnum.CANCELING.getCode());
            }
            try {
                Object obj = ObjectContextHolder.getInstance().getBean(muleParticipant.getTargetClass());
                String targetMethod = muleParticipant.getTargetMethod();
                if (StrKit.notBlank((String)targetMethod)) {
                    ParticipantKit.exeParticipantMethod(retryNum, obj, targetMethod, muleParticipant.getArgs(), muleParticipant.getParameterTypes());
                } else {
                    String methodName;
                    String string = methodName = status ? muleParticipant.getConfirmMethod() : muleParticipant.getCancelMethod();
                    if (StrKit.notBlank((String)methodName)) {
                        ParticipantKit.exeParticipantMethodParentalAppointment(retryNum, obj, methodName, muleParticipant.getArgs(), muleParticipant.getParameterTypes());
                    }
                }
                muleParticipants.remove(i);
                continue;
            }
            catch (ParticipantMethodExeFailureException e) {
                muleParticipant.setRetries(retries + retryNum);
                LogKit.error((Logger)log, (String)e.getMessage(), (Throwable)e.getCause());
            }
        }
    }

    public static void exeParticipantMethodParentalAppointment(int retryMax, Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws ParticipantMethodExeFailureException {
        if (!MethodKit.existSpecifiedMethod(object.getClass(), (String)methodName, (Class[])parameterTypes)) {
            if (CollectionKit.isEmpty((Object[])args)) {
                throw new ParticipantMethodExeFailureException("\u53c2\u4e0e\u8005\u3010{}\u3011\u65b9\u6cd5\u3010{}()\u3011\u90fd\u4e0d\u5b58\u5728\u6216\u672a\u6b63\u786e\u7684\u5b9a\u4e49...", object.getClass(), methodName);
            }
            args = new Object[]{};
            parameterTypes = new Class[]{};
            if (!MethodKit.existSpecifiedMethod(object.getClass(), (String)methodName, (Class[])parameterTypes)) {
                throw new ParticipantMethodExeFailureException("\u53c2\u4e0e\u8005\u3010{}\u3011\u65b9\u6cd5\u3010{}({} ) \u548c {}()\u3011\u90fd\u4e0d\u5b58\u5728\u6216\u672a\u6b63\u786e\u7684\u5b9a\u4e49...", object.getClass(), methodName, StrKit.listStitchingStr(type -> " " + type, (Object[])parameterTypes), methodName);
            }
        }
        ParticipantKit.exeParticipantMethod(retryMax, object, methodName, args, parameterTypes);
    }

    public static void exeParticipantMethod(int retryMax, Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws ParticipantMethodExeFailureException {
        try {
            MethodKit.invokeExactMethod((Object)object, (String)methodName, (Object[])args, (Class[])parameterTypes);
        }
        catch (NoSuchMethodException e) {
            ParticipantKit.recursiveExeParticipantMethod(retryMax, object, methodName, args, parameterTypes, e, () -> LogKit.error((Logger)log, (String)"\u53c2\u4e0e\u8005\u3010{}\u3011\u65b9\u6cd5\u3010{}({} )\u3011\u4e0d\u5b58\u5728\u6216\u672a\u6b63\u786e\u7684\u5b9a\u4e49...", () -> new Object[]{object.getClass(), methodName, StrKit.listStitchingStr(type -> " " + type, (Object[])parameterTypes), e}));
        }
        catch (IllegalAccessException e) {
            ParticipantKit.recursiveExeParticipantMethod(retryMax, object, methodName, args, parameterTypes, e, () -> LogKit.error((Logger)log, (String)"\u53c2\u4e0e\u8005\u3010{}\u3011\u65b9\u6cd5\u3010{}\u3011\u65e0\u6cd5\u901a\u8fc7\u53cd\u5c04\u8bbf\u95ee...", () -> new Object[]{object.getClass(), methodName, e}));
        }
        catch (InvocationTargetException e) {
            ParticipantKit.recursiveExeParticipantMethod(retryMax, object, methodName, args, parameterTypes, e, () -> LogKit.warn((Logger)log, (String)"\u6267\u884c\u53c2\u4e0e\u8005\u3010{}\u3011\u65b9\u6cd5\u3010{}\u3011\u65f6\u53d1\u751f\u4f8b\u5916:\u3010{} : {}\u3011\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570{}", () -> new Object[]{object.getClass(), methodName, e.getCause().getClass().getSimpleName(), e.getCause().getMessage(), retryMax - 1}));
        }
    }

    private static void recursiveExeParticipantMethod(int retryMax, Object object, String methodName, Object[] args, Class<?>[] parameterTypes, Exception e, Consumption consumption) {
        if (retryMax <= 1) {
            throw new ParticipantMethodExeFailureException(e, "\u6267\u884c\u53c2\u4e0e\u8005\u3010{}\u3011\u65b9\u6cd5\u3010{}\u3011\u591a\u6b21\u91cd\u8bd5\u540e\u4f9d\u7136\u53d1\u751f\u4f8b\u5916... ", object.getClass(), methodName);
        }
        consumption.accept();
        ParticipantKit.exeParticipantMethod(retryMax - 1, object, methodName, args, parameterTypes);
    }
}

