/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.dateTime.DateTime;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.mule.tccTransaction.MuleTccConfig;
import net.lulihu.mule.tccTransaction.MuleTccShutdownManage;
import net.lulihu.mule.tccTransaction.enums.MuleActionEnum;
import net.lulihu.mule.tccTransaction.enums.MuleRoleEnum;
import net.lulihu.mule.tccTransaction.kit.ParticipantKit;
import net.lulihu.mule.tccTransaction.kit.TransactionContextLocalKit;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.MuleTransactionCompensations;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.MuleTccShutdownService;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorService;
import net.lulihu.mule.tccTransaction.service.TransactionSelfHealingProgramService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleTccTransactionSelfHealingProgram
implements Runnable,
TransactionSelfHealingProgramService,
MuleTccShutdownService {
    private static final Logger log = LoggerFactory.getLogger(MuleTccTransactionSelfHealingProgram.class);
    private TransactionCoordinatorService transactionCoordinatorService;
    private ScheduledExecutorService scheduledExecutorService;
    private int retryMax;
    private int recoverTimeInterval;
    private long firstRecoveryTimeInterval;
    private int deleteExcessCompensationRecordInitialDelay;

    @Override
    public void run() {
        LogKit.debug((Logger)log, (String)"\u6267\u884c\u81ea\u6211\u68c0\u67e5...");
        try {
            this.transactionCompensate();
            this.transactionCoordinatorService.deleteExcessCompensationRecord(this.deleteExcessCompensationRecordInitialDelay, null);
        }
        catch (Exception e) {
            LogKit.error((Logger)log, (String)"\u6267\u884c\u81ea\u6211\u68c0\u67e5\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void transactionCompensate() {
        List<MuleTransaction> transactions = this.transactionCoordinatorService.getAllMuleTransaction(null);
        if (CollectionKit.isEmpty(transactions)) {
            return;
        }
        TransactionContext context = new TransactionContext();
        context.setRole(MuleRoleEnum.SELF_HEALING.getCode());
        TransactionContextLocalKit.set(context);
        for (MuleTransaction transaction : transactions) {
            boolean success;
            int status = transaction.getStatus();
            DateTime createTime = DateTimeKit.parse((String)transaction.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
            int compare = Long.compare(createTime.getTime() + this.firstRecoveryTimeInterval, DateTimeKit.date().getTime());
            if (compare > 0) continue;
            context.setTransId(transaction.getTransId());
            if (status == MuleActionEnum.AFTER_TRYING.getCode()) {
                this.afterTrying(transaction);
                continue;
            }
            if (status != MuleActionEnum.CONFIRMING.getCode() && status != MuleActionEnum.CANCELING.getCode() || !(success = this.transactionCoordinatorService.getOptimisticLocks(transaction, this.recoverTimeInterval, null))) continue;
            boolean transactionStatus = status == MuleActionEnum.CONFIRMING.getCode();
            ParticipantKit.exeParticipantMethod(this.transactionCoordinatorService, transactionStatus, (Integer)this.retryMax, transaction);
        }
    }

    private void afterTrying(MuleTransaction transaction) {
        MuleTransactionCompensations transactionCompensations = this.transactionCoordinatorService.getMuleTransactionCompensationsLog(transaction, null);
        if (transactionCompensations == null) {
            return;
        }
        boolean success = this.transactionCoordinatorService.getOptimisticLocks(transaction, this.recoverTimeInterval, null);
        if (success) {
            transaction.setStatus(transactionCompensations.getStatus());
            this.transactionCoordinatorService.deleteTransactionCompensationsLog(transactionCompensations, null);
            if (MuleActionEnum.DELETE.getCode() == transactionCompensations.getStatus()) {
                this.transactionCoordinatorService.delete(transaction, null);
            } else {
                boolean transactionStatus = transaction.getStatus() == MuleActionEnum.CONFIRMING.getCode();
                ParticipantKit.exeParticipantMethod(this.transactionCoordinatorService, transactionStatus, (Integer)this.retryMax, transaction);
            }
        }
    }

    @Override
    public void initialization(TransactionCoordinatorService transactionCoordinatorService, MuleTccConfig config) {
        LogKit.debug((Logger)log, (String)"\u521d\u59cb\u5316\u81ea\u6211\u4fee\u590d\u7a0b\u5e8f...");
        this.transactionCoordinatorService = transactionCoordinatorService;
        this.retryMax = config.getRetryMax();
        this.recoverTimeInterval = config.getRecoverTimeInterval();
        this.firstRecoveryTimeInterval = TimeUnit.SECONDS.toMillis(config.getFirstRecoveryTimeInterval());
        this.deleteExcessCompensationRecordInitialDelay = config.getDeleteExcessCompensationRecordInitialDelay();
        AtomicInteger atomic = new AtomicInteger();
        ThreadFactory threadFactory = thread -> new Thread(new ThreadGroup("Mule-SelfHealingProgram"), thread, "Mule\u81ea\u6211\u68c0\u67e5\u7a0b\u5e8f-" + atomic.incrementAndGet());
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(config.getScheduledThreadMax(), threadFactory);
        this.scheduledExecutorService.scheduleWithFixedDelay(this, config.getScheduledInitDelay(), config.getScheduledDelay(), TimeUnit.SECONDS);
        MuleTccShutdownManage.getInstance().addComponents(this);
    }

    @Override
    public void shutdown() {
        LogKit.debug((Logger)log, (String)"\u81ea\u6211\u68c0\u67e5\u7a0b\u5e8f\u5f00\u59cb\u5173\u95ed...");
        LogKit.debug((Logger)log, (String)"\u81ea\u6211\u68c0\u67e5\u7a0b\u5e8f\u505c\u6b62\u751f\u4ea7\u65b0\u7684\u7ebf\u7a0b...");
        this.scheduledExecutorService.shutdown();
        boolean stop = false;
        do {
            try {
                stop = this.scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS);
                LogKit.debug((Logger)log, (String)"\u81ea\u6211\u68c0\u67e5\u7a0b\u5e8f\u5173\u95ed\u76d1\u542c - {}...", (Object)(stop ? "\u5173\u95ed\u6210\u529f" : "\u4efb\u52a1\u8fd8\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7b49\u5f85"));
            }
            catch (InterruptedException e) {
                if (!Thread.interrupted()) continue;
                LogKit.warn((Logger)log, (String)"\u81ea\u6211\u68c0\u67e5\u7a0b\u5e8f\u5173\u95ed\u7ebf\u7a0b\u7b49\u5f85\u8fc7\u7a0b\u4e2d\u88ab\u6253\u65ad...");
            }
        } while (!stop);
    }

    @Override
    public int order() {
        return 1;
    }
}

