/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.mule.tccTransaction.service.MuleTccShutdownService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleTccShutdownManage {
    private static final Logger log = LoggerFactory.getLogger(MuleTccShutdownManage.class);
    private final Map<Integer, List<MuleTccShutdownService>> orderComponents = new TreeMap(Comparator.naturalOrder());
    private final List<MuleTccShutdownService> randomComponents = new ArrayList<MuleTccShutdownService>();

    private MuleTccShutdownManage() {
    }

    public static MuleTccShutdownManage getInstance() {
        return MuleTccShutdownManageEnum.INSTANCE.getMuleTccShutdownManage();
    }

    public synchronized void addComponents(MuleTccShutdownService shutdownService) {
        int order = shutdownService.order();
        if (order > -1) {
            this.orderComponents.computeIfAbsent(order, k -> new ArrayList()).add(shutdownService);
        } else {
            this.randomComponents.add(shutdownService);
        }
        LogKit.debug((Logger)log, (String)"\u3010{}\u3011\u6210\u529f\u6dfb\u52a0\u5230Mule Tcc\u7ec4\u4ef6\u5173\u95ed\u7cfb\u7edf...", () -> new Object[]{shutdownService.componentName()});
    }

    synchronized void startShutdown() {
        LogKit.debug((Logger)log, (String)"Mule Tcc \u5f00\u59cb\u9010\u6b65\u5173\u95ed\u7ec4\u4ef6...");
        Map<Integer, List<MuleTccShutdownService>> orderComponents = this.orderComponents;
        for (Integer order : orderComponents.keySet()) {
            List<MuleTccShutdownService> shutdownServices = orderComponents.get(order);
            for (MuleTccShutdownService shutdownService : shutdownServices) {
                this.shutdown(shutdownService);
            }
        }
        List<MuleTccShutdownService> randomComponents = this.randomComponents;
        for (MuleTccShutdownService randomComponent : randomComponents) {
            this.shutdown(randomComponent);
        }
        LogKit.debug((Logger)log, (String)"Mule Tcc \u7ec4\u4ef6\u5168\u90e8\u5173\u95ed...");
    }

    private void shutdown(MuleTccShutdownService shutdownService) {
        String componentName = shutdownService.componentName();
        try {
            LogKit.debug((Logger)log, (String)"\u7ec4\u4ef6\u5bf9\u8c61\u3010{}\u3011\u5f00\u59cb\u5173\u95ed...", (Object)componentName);
            shutdownService.shutdown();
        }
        catch (Exception e) {
            LogKit.error((Logger)log, (String)"\u5173\u95ed\u7ec4\u4ef6\u5bf9\u8c61\u3010{}\u3011\u65f6\u53d1\u751f\u4f8b\u5916", (Object)componentName, (Object)e);
        }
    }

    private static enum MuleTccShutdownManageEnum {
        INSTANCE;

        private MuleTccShutdownManage muleTccShutdownManage = new MuleTccShutdownManage();

        public MuleTccShutdownManage getMuleTccShutdownManage() {
            return this.muleTccShutdownManage;
        }
    }
}

