/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.lulihu.ObjectKit.KryoKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.mule.tccTransaction.annotation.MuleTcc;
import net.lulihu.mule.tccTransaction.kit.ObjectContextHolder;
import net.lulihu.mule.tccTransaction.service.TransactionHandlerService;
import net.lulihu.mule.tccTransaction.service.TransactionMethodProxyService;

public class MuleTccProxyInvocationHandler
implements InvocationHandler {
    private final TransactionMethodProxyService methodProxyService;
    private final InvocationHandler invocationHandler;
    private final Class<?> beanClass;

    public MuleTccProxyInvocationHandler(TransactionMethodProxyService methodProxyService, InvocationHandler invocationHandler, Class<?> beanClass) {
        this.methodProxyService = methodProxyService;
        this.invocationHandler = invocationHandler;
        this.beanClass = beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MuleTcc muleTcc = method.getAnnotation(MuleTcc.class);
        if (muleTcc == null) {
            return this.invokeTargetMethod(proxy, method, args);
        }
        Object[] cloneArgs = (Object[])KryoKit.clone((Object)args);
        TransactionHandlerService handlerService = this.methodProxyService.beforeTransactionHandler();
        boolean proceed = this.methodProxyService.before(handlerService, this.beanClass, method, cloneArgs);
        try {
            if (proceed) {
                Object result = this.invokeTargetMethod(proxy, method, cloneArgs);
                Object object = this.methodProxyService.result(handlerService, result);
                return object;
            }
        }
        catch (Exception e) {
            this.methodProxyService.exception(handlerService, e);
        }
        finally {
            this.methodProxyService.after(handlerService);
        }
        return ObjectKit.getDefaultValue(method.getReturnType());
    }

    private Object invokeTargetMethod(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.invocationHandler != null) {
            return this.invocationHandler.invoke(proxy, method, args);
        }
        return method.invoke(ObjectContextHolder.getInstance().getBean(this.beanClass), args);
    }

    public static Object generateProxyObject(TransactionMethodProxyService methodProxyService, InvocationHandler invocationHandler, Object targetObject) {
        return MuleTccProxyInvocationHandler.generateProxyObject(methodProxyService, invocationHandler, targetObject, targetObject.getClass());
    }

    public static Object generateProxyObject(TransactionMethodProxyService methodProxyService, InvocationHandler invocationHandler, Object targetObject, Class<?> beanClass) {
        Class<?> clazz = targetObject.getClass();
        ClassLoader loader = clazz.getClassLoader();
        Class<?>[] interfaces = clazz.getInterfaces();
        MuleTccProxyInvocationHandler proxyInvocationHandler = new MuleTccProxyInvocationHandler(methodProxyService, invocationHandler, beanClass);
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)proxyInvocationHandler);
    }
}

