/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccSpringcloud;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.lulihu.ObjectKit.KryoKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.mule.tccTransaction.kit.ObjectContextHolder;
import net.lulihu.mule.tccTransaction.service.TransactionHandlerService;
import net.lulihu.mule.tccTransaction.service.TransactionMethodProxyService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MuleTccTransactionAspectJ
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(MuleTccTransactionAspectJ.class);
    @Autowired
    private TransactionMethodProxyService methodProxyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(net.lulihu.mule.tccTransaction.annotation.MuleTcc)")
    public Object interceptTccTransactionMethod(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Object[] args = (Object[])KryoKit.clone((Object)point.getArgs());
        if (Proxy.isProxyClass(target.getClass())) {
            return point.proceed();
        }
        TransactionHandlerService handlerService = this.methodProxyService.beforeTransactionHandler();
        Class firstExists = ObjectContextHolder.getInstance().chooseFirstExists(target, method);
        boolean proceed = this.methodProxyService.before(handlerService, firstExists, method, args);
        try {
            if (proceed) {
                Object result = point.proceed();
                Object object = this.methodProxyService.result(handlerService, result);
                return object;
            }
        }
        catch (Exception e) {
            this.methodProxyService.exception(handlerService, (Throwable)e);
        }
        finally {
            this.methodProxyService.after(handlerService);
        }
        return ObjectKit.getDefaultValue(method.getReturnType());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

