/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccSpringcloud;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lulihu.ObjectKit.ThreadLocalKit;
import net.lulihu.mule.tccSpringcloud.MuleTccConfigProperties;
import net.lulihu.mule.tccTransaction.kit.ServletRequestLocalKit;
import net.lulihu.mule.tccTransaction.kit.StarterTransactionExecutorEventLocalKit;
import net.lulihu.mule.tccTransaction.kit.StarterTransactionHandlerKit;
import net.lulihu.mule.tccTransaction.service.TransactionExecutorEventService;

@WebFilter(filterName="muleTccRequestFilter", urlPatterns={"/*"})
public class MuleTccHttpServletRequestHandlerFilter
implements Filter {
    private final List<Integer> successCode;

    public void init(FilterConfig filterConfig) {
    }

    public MuleTccHttpServletRequestHandlerFilter(MuleTccConfigProperties muleTccConfigProperties) {
        this.successCode = muleTccConfigProperties.getSuccessCode();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ServletRequestLocalKit.set((HttpServletRequest)((HttpServletRequest)request));
        try {
            filterChain.doFilter(request, response);
            int status = ((HttpServletResponse)response).getStatus();
            if (this.successCode.contains(status)) {
                StarterTransactionHandlerKit.exeConfirm((TransactionExecutorEventService)StarterTransactionExecutorEventLocalKit.get());
            } else {
                StarterTransactionHandlerKit.exeCancel((TransactionExecutorEventService)StarterTransactionExecutorEventLocalKit.get());
            }
        }
        catch (Exception e) {
            StarterTransactionHandlerKit.exeCancel((TransactionExecutorEventService)StarterTransactionExecutorEventLocalKit.get());
            throw e;
        }
        finally {
            ThreadLocalKit.clearAll();
        }
    }

    public void destroy() {
    }
}

