/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccSpringcloud;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.mule.tccTransaction.MuleTccProxyInvocationHandler;
import net.lulihu.mule.tccTransaction.annotation.MuleTcc;
import net.lulihu.mule.tccTransaction.service.TransactionMethodProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class MuleTccBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(MuleTccBeanPostProcessor.class);
    private final TransactionMethodProxyService methodProxyService;

    public MuleTccBeanPostProcessor(TransactionMethodProxyService methodProxyService) {
        this.methodProxyService = methodProxyService;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        Method[] methods;
        Class<?> aClass = bean.getClass();
        if (!Proxy.isProxyClass(aClass)) {
            return bean;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(bean);
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(aClass)) {
            MuleTcc muleTcc = (MuleTcc)AnnotationUtils.findAnnotation((Method)method, MuleTcc.class);
            if (null == muleTcc) continue;
            try {
                return MuleTccProxyInvocationHandler.generateProxyObject((TransactionMethodProxyService)this.methodProxyService, (InvocationHandler)handler, (Object)bean, Class.forName(beanName));
            }
            catch (ClassNotFoundException e) {
                throw new BeanCurrentlyInCreationException(beanName, StrKit.format((String)"\u3010{}\u3011\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\u7c7b\u578b", (Object[])new Object[]{beanName}));
            }
        }
        return bean;
    }
}

