/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.validated;

import java.util.Date;
import net.lulihu.AssertKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.common_util.validated.ParamValidated;
import net.lulihu.common_util.validated.annotation.DateStrFormat;
import net.lulihu.common_util.validated.annotation.NumberRange;
import net.lulihu.common_util.validated.annotation.StringRange;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.exception.ExceptionEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatedUtil {
    private static final Logger log = LoggerFactory.getLogger(ValidatedUtil.class);

    public static void numberRange(Object value, NumberRange ann, ExceptionEnum defaultException) {
        AssertKit.isTrue((!ParamValidated.isOneExist((Number)value, ValidatedUtil.getNumberRange(value.getClass(), ann)) ? 1 : 0) != 0, () -> ParamValidated.throwException(ann.message(), defaultException));
    }

    public static void stringRange(Object value, StringRange stringRange, ExceptionEnum defaultException) {
        int minLen;
        int maxLen;
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(StrKit.format((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u4f8b\u5916:@StringRange\u6ce8\u89e3\u65e0\u6cd5\u6821\u9a8c{}", (Object[])new Object[]{value.getClass()}));
        }
        String param = (String)value;
        Object[] range = stringRange.value();
        if (CollectionKit.isNotEmpty((Object[])range) && !ParamValidated.isOneExist(param, (String[])range)) {
            ParamValidated.throwException(stringRange.message(), defaultException);
        }
        if ((maxLen = stringRange.maxLen()) != -1 && param.length() > maxLen) {
            ParamValidated.throwException(stringRange.message(), defaultException);
        }
        if ((minLen = stringRange.minLen()) != -1 && param.length() < minLen) {
            ParamValidated.throwException(stringRange.message(), defaultException);
        }
    }

    public static void dateStrFormat(String value, DateStrFormat format, ExceptionEnum defaultException) {
        if (StrKit.isEmpty((String)value)) {
            return;
        }
        try {
            String[] times = format.plural() ? value.split(format.pluralSep()) : new String[]{value};
            for (String time : times) {
                String formatTime = DateTimeKit.format((Date)DateTimeKit.parse((String)time, (String)format.value()), (String)format.value());
                if (time.equals(formatTime)) continue;
                ParamValidated.throwException(format.message(), defaultException);
            }
        }
        catch (Exception e) {
            log.warn("\u68c0\u67e5\u65f6\u95f4\u5b57\u6bb5\u7c7b\u578b\u4f8b\u5916", (Throwable)e);
            ParamValidated.throwException(format.message(), defaultException);
        }
    }

    private static Number[] getNumberRange(Class<?> valueClass, NumberRange ann) {
        if (valueClass.equals(Integer.TYPE) || valueClass.equals(Integer.class)) {
            return CollectionKit.wrap((int[])ann.INTS());
        }
        if (valueClass.equals(Double.TYPE) || valueClass.equals(Double.class)) {
            return CollectionKit.wrap((double[])ann.DOUBLES());
        }
        if (valueClass.equals(Long.TYPE) || valueClass.equals(Long.class)) {
            return CollectionKit.wrap((long[])ann.LONGS());
        }
        if (valueClass.equals(Short.TYPE) || valueClass.equals(Short.class)) {
            return CollectionKit.wrap((short[])ann.SHORTS());
        }
        if (valueClass.equals(Byte.TYPE) || valueClass.equals(Byte.class)) {
            return CollectionKit.wrap((byte[])ann.BYTES());
        }
        if (valueClass.equals(Float.TYPE) || valueClass.equals(Float.class)) {
            return CollectionKit.wrap((float[])ann.FLOATS());
        }
        throw new IllegalArgumentException("\u7c7b\u578b\u4e0d\u5339\u914d\u4f8b\u5916");
    }
}

