/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.validated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.validation.Valid;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.common_util.validated.AnnotationValidated;
import net.lulihu.exception.ExceptionEnum;
import net.lulihu.exception.ParamResolveException;
import net.lulihu.exception.ToolBoxException;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ParamValidated {
    public static void examine(Object obj) {
        ParamValidated.examine(obj, (ExceptionEnum)new ParamResolveException());
    }

    public static void examine(Object obj, ExceptionEnum exceptionEnum) {
        try {
            for (Field field : ReflectKit.getAllFieldsList(obj.getClass())) {
                Annotation[] anns = field.getAnnotations();
                Object value = FieldUtils.readField((Field)field, (Object)obj, (boolean)true);
                for (Annotation ann : anns) {
                    if (ann instanceof Valid) {
                        ParamValidated.validated(value);
                        continue;
                    }
                    AnnotationValidated.examine(ann, value, exceptionEnum);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new ToolBoxException((Throwable)e);
        }
    }

    private static void validated(Object value) {
        if (ObjectKit.hasEmpty((Object)value)) {
            return;
        }
        if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                ParamValidated.examine(obj);
            }
        } else if (BeanKit.isBean(value.getClass())) {
            ParamValidated.examine(value);
        }
    }

    public static void isTrue(boolean boo, ExceptionEnum exceptionEnum) {
        if (boo) {
            throw new ParamResolveException(exceptionEnum);
        }
    }

    public static void isTrue(boolean boo) {
        if (boo) {
            throw new ParamResolveException();
        }
    }

    public static void isNotEmpty(ExceptionEnum exceptionEnum, Object ... params) {
        ParamValidated.isNotEmpty(exceptionEnum, null, params);
    }

    public static void isNotEmpty(ExceptionEnum exceptionEnum, String errorMessage, Object ... params) {
        boolean isEmpty = ParamValidated.isOneEmpty(params);
        if (isEmpty) {
            ParamValidated.throwException(errorMessage, exceptionEnum);
        }
    }

    public static void isNotEmpty(Object ... params) {
        ParamValidated.isNotEmpty((ExceptionEnum)new ParamResolveException(), params);
    }

    public static void isEmpty(ExceptionEnum exceptionEnum, Object ... params) {
        boolean isEmpty = ParamValidated.isAllEmpty(params);
        if (!isEmpty) {
            ParamValidated.throwException(null, exceptionEnum);
        }
    }

    public static void isEmpty(Object ... params) {
        ParamValidated.isEmpty((ExceptionEnum)new ParamResolveException(), params);
    }

    public static boolean hasNotEmpty(Object ... param) {
        return !ParamValidated.isOneEmpty(param);
    }

    public static boolean isOneEmpty(Object ... os) {
        for (Object o : os) {
            if (!ObjectKit.hasEmpty((Object)o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... os) {
        for (Object o : os) {
            if (ObjectKit.hasEmpty((Object)o)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOneExist(String str, String[] os) {
        if (ObjectKit.hasEmpty((Object)str) || CollectionKit.isEmpty((Object[])os)) {
            return false;
        }
        for (String o : os) {
            if (!str.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneExist(Number str, Number[] os) {
        if (ObjectKit.hasEmpty((Object)str) || CollectionKit.isEmpty((Object[])os)) {
            return false;
        }
        for (Number o : os) {
            if (!str.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static void throwException(String errorMessage, ExceptionEnum defaultException) {
        if (StrKit.isNotEmpty((String)errorMessage)) {
            throw new ParamResolveException(errorMessage, new Object[0]);
        }
        if (defaultException instanceof ParamResolveException) {
            throw (ParamResolveException)defaultException;
        }
        throw new ParamResolveException(defaultException);
    }
}

