/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.validated;

import java.lang.annotation.Annotation;
import net.lulihu.common_util.validated.ParamValidated;
import net.lulihu.common_util.validated.ValidatedUtil;
import net.lulihu.common_util.validated.annotation.DateStrFormat;
import net.lulihu.common_util.validated.annotation.NotNull;
import net.lulihu.common_util.validated.annotation.NumberRange;
import net.lulihu.common_util.validated.annotation.StringRange;
import net.lulihu.exception.ExceptionEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationValidated {
    private static final Logger log = LoggerFactory.getLogger(AnnotationValidated.class);

    public static void examine(Annotation ann, Object value, ExceptionEnum defaultException) {
        if (ann instanceof NotNull) {
            ParamValidated.isNotEmpty(defaultException, ((NotNull)ann).message(), value);
        }
        if (ann instanceof DateStrFormat) {
            ValidatedUtil.dateStrFormat((String)value, (DateStrFormat)ann, defaultException);
        }
        if (ann instanceof StringRange) {
            ValidatedUtil.stringRange(value, (StringRange)ann, defaultException);
        }
        if (ann instanceof NumberRange) {
            ValidatedUtil.numberRange(value, (NumberRange)ann, defaultException);
        }
    }
}

