/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.spring;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lulihu.ObjectKit.HttpKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.common_util.fastJson.FastJson;
import net.lulihu.http.RequestExpandWrapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

public class SpringHttpKit {
    private static final Logger log = LoggerFactory.getLogger(SpringHttpKit.class);

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (null == servletRequestAttributes) {
            return null;
        }
        return servletRequestAttributes.getResponse();
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (null == servletRequestAttributes) {
            return null;
        }
        return HttpKit.getRequest((HttpServletRequest)servletRequestAttributes.getRequest());
    }

    public static String getHeader(String key) {
        return Objects.requireNonNull(SpringHttpKit.getRequest()).getHeader(key);
    }

    public static Map<String, Object> getHeaderParam() {
        return HttpKit.getHeaderParam((HttpServletRequest)SpringHttpKit.getRequest());
    }

    public static Map<String, Object> getAllRequestParams(HttpServletRequest request, Object handler, Map<String, Object> result) {
        HandlerMethod handlerMethod = null;
        if (handler instanceof HandlerMethod) {
            handlerMethod = (HandlerMethod)handler;
        } else {
            log.warn("spring \u65b9\u6cd5\u5904\u7406\u5bf9\u8c61\u53d1\u751f\u6539\u53d8");
        }
        return SpringHttpKit.getAllRequestParams(request, handlerMethod, result);
    }

    public static Map<String, Object> getAllRequestParams(HttpServletRequest request, HandlerMethod handlerMethod, Map<String, Object> result) {
        if (ObjectKit.hasNotEmpty((Object)handlerMethod)) {
            Annotation[][] annotationArray = handlerMethod.getMethod().getParameterAnnotations();
            int n = annotationArray.length;
            block0: for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotation;
                for (Annotation annotation : parameterAnnotation = annotationArray[i]) {
                    if (!(annotation instanceof RequestBody) && !(annotation instanceof FastJson)) continue;
                    RequestExpandWrapperUtil.requestParams((HttpServletRequest)request, result);
                    continue block0;
                }
            }
        } else {
            HttpKit.getRequestParameters((HttpServletRequest)request, result);
        }
        return result;
    }

    public static String getClientIP() {
        return HttpKit.getClientIP((HttpServletRequest)SpringHttpKit.getRequest());
    }
}

