/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.spring;

import net.lulihu.Assert;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.NonNull;

public class SpringContextHolder
implements ApplicationContextAware {
    private static ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String beanName) {
        SpringContextHolder.assertApplicationContext();
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertApplicationContext();
        return (T)applicationContext.getBean(requiredType);
    }

    public void registerBean(Object obj) {
        SpringContextHolder.assertApplicationContext();
        Assert.notNull((Object)obj);
        this.registerBean(obj.getClass().getName(), obj);
    }

    public void registerBean(String beanName, Object obj) {
        SpringContextHolder.assertApplicationContext();
        Assert.notNull((Object)beanName);
        Assert.notNull((Object)obj);
        applicationContext.getBeanFactory().registerSingleton(beanName, obj);
    }

    private static void assertApplicationContext() {
        Assert.notNull((Object)applicationContext, (String)"\u4e0a\u4e0b\u6587\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u662f\u5426\u5c06\u672c\u5bf9\u8c61\u6ce8\u5165\u5bb9\u5668");
    }
}

