/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.fastJson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.common_util.fastJson.FastJson;
import net.lulihu.http.RequestExpandWrapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class FastJsonHttpMessageResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(FastJsonHttpMessageResolver.class);

    public FastJsonHttpMessageResolver() {
        log.info("==== \u52a0\u8f7dFastJsonHttpMessageResolver\u7ec4\u4ef6 ====");
    }

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        Class parameterType = parameter.getParameterType();
        return parameter.hasParameterAnnotation(FastJson.class) && (BeanKit.isBean((Class)parameterType) || ClassKit.isAssignable(List.class, (Class)parameterType));
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Type genericType;
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        Class parameterType = parameter.getParameterType();
        if (BeanKit.isBean((Class)parameterType)) {
            Map requestParameters = RequestExpandWrapperUtil.requestParams((HttpServletRequest)servletRequest, new HashMap());
            if (MapKit.isEmpty((Map)requestParameters)) {
                return ClassKit.newInstanceConstructorsDefaultValue((Class)parameterType);
            }
            try {
                String json = JSON.toJSONString((Object)requestParameters);
                return JSON.parseObject((String)json, (Class)parameterType);
            }
            catch (JSONException e) {
                return BeanKit.fillBeanField((Object)ClassKit.newInstance((Class)parameterType), field -> {
                    Object value = requestParameters.get(field.getName());
                    if (ObjectKit.hasEmpty(value)) {
                        return null;
                    }
                    if (!value.getClass().equals(field.getType())) {
                        return this.distribute(value, field);
                    }
                    return value;
                });
            }
        }
        if (ClassKit.isAssignable(List.class, (Class)parameterType) && (genericType = parameter.getParameter().getParameterizedType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return RequestExpandWrapperUtil.requestParams((HttpServletRequest)servletRequest, (Class)((Class)pt.getActualTypeArguments()[0]));
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5c01\u88c5\u7c7b\u578b...");
    }

    private Object distribute(Object value, Field field) {
        String val = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
        Class<?> clazz = field.getType();
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.processCollection(val, field);
        }
        return JSON.parseObject((String)val, clazz);
    }

    private Object processCollection(String value, Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return JSON.parseArray((String)value, (Class)((Class)pt.getActualTypeArguments()[0]));
        }
        return null;
    }
}

