/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.exception;

import java.util.List;
import java.util.Objects;
import javax.validation.ConstraintViolationException;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.common_util.controller_result.Result;
import net.lulihu.common_util.exception.BusinessException;
import net.lulihu.common_util.exception.BusinessExceptionEnum;
import net.lulihu.common_util.spring.SpringHttpKit;
import net.lulihu.common_util.validated.spring.ParamViolationExceptionUtil;
import net.lulihu.exception.ExceptionEnum;
import net.lulihu.exception.ParamResolveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ResponseBody
public abstract class BusinessExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(BusinessExceptionHandler.class);

    @ExceptionHandler(value={BusinessException.class})
    public Object business(BusinessException e) {
        log.warn(StrKit.format((String)"{}-{}", (Object[])new Object[]{e.getCode(), e.getMessage()}), (Throwable)e);
        return this.unifiedReturn(e);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Object unknown(RuntimeException e) {
        log.error("\u8fd0\u884c\u65f6\u672a\u77e5\u5f02\u5e38:", (Throwable)e);
        return this.unifiedReturn(BusinessExceptionEnum.EXPECTED_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, ParamResolveException.class, ConstraintViolationException.class})
    public Object argumentTypeMismatch(Exception e) {
        if (e instanceof ConstraintViolationException) {
            List<String> messages = ParamViolationExceptionUtil.getParamViolationMessages((ConstraintViolationException)e);
            log.warn("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5\u4f8b\u5916:{}", messages);
            return this.unifiedReturn(BusinessExceptionEnum.PARAM_NOT_REQUIRE, messages);
        }
        log.warn("\u53c2\u6570\u89e3\u6790\u4f8b\u5916:{}", (Object)e.getMessage());
        return this.unifiedReturn(BusinessExceptionEnum.PARAM_NOT_REQUIRE);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Object httpMessageNotReadable(HttpMessageNotReadableException e) {
        log.warn("\u7f3a\u5c11\u5fc5\u8981\u7684http\u8bf7\u6c42\u6b63\u6587", (Throwable)e);
        return this.unifiedReturn(BusinessExceptionEnum.HTTP_MESSAGE_NOT_READABLE);
    }

    public Object unifiedReturn(ExceptionEnum exceptionEnum) {
        return this.unifiedReturn(exceptionEnum, null);
    }

    public Object unifiedReturn(ExceptionEnum exceptionEnum, Object data) {
        Integer httpCode = exceptionEnum.getHttpCode();
        if (null != httpCode) {
            Objects.requireNonNull(SpringHttpKit.getResponse()).setStatus(httpCode.intValue());
        }
        return Result.exception(exceptionEnum, data);
    }
}

