/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.exception;

import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ExceptionEnum;

public class BusinessException
extends RuntimeException
implements ExceptionEnum {
    private static final Integer defaultHttpCode = 555;
    private static final Integer defaultCode = 999;
    private Integer code;
    private Integer httpCode;
    private String message;

    public BusinessException(ExceptionEnum exceptionEnum) {
        this(exceptionEnum.getHttpCode(), exceptionEnum.getCode(), exceptionEnum.getMessage());
    }

    public BusinessException(Throwable cause, ExceptionEnum exceptionEnum) {
        this(cause, exceptionEnum.getHttpCode(), exceptionEnum.getCode(), exceptionEnum.getMessage());
    }

    public BusinessException(String message) {
        this(null, defaultHttpCode, defaultCode, message);
    }

    public BusinessException(Integer code, String message) {
        this(null, defaultHttpCode, code, message);
    }

    public BusinessException(Integer httpCode, Integer code, String message) {
        this(null, httpCode, code, message);
    }

    public BusinessException(String message, Object ... values) {
        this(null, defaultHttpCode, defaultCode, StrKit.format((String)message, (Object[])values));
    }

    public BusinessException(Integer code, String message, Object ... values) {
        this(null, defaultHttpCode, code, StrKit.format((String)message, (Object[])values));
    }

    public BusinessException(Throwable cause, String message, Object ... values) {
        this(cause, defaultHttpCode, defaultCode, StrKit.format((String)message, (Object[])values));
    }

    public BusinessException(Throwable cause, Integer code, String message, Object ... values) {
        this(cause, defaultHttpCode, code, StrKit.format((String)message, (Object[])values));
    }

    public BusinessException(Integer httpCode, Integer code, String message, Object ... values) {
        this(null, httpCode, code, StrKit.format((String)message, (Object[])values));
    }

    public BusinessException(Throwable cause, Integer httpCode, Integer code, String message, Object ... values) {
        this(cause, httpCode, code, StrKit.format((String)message, (Object[])values));
    }

    private BusinessException(Throwable cause, Integer httpCode, Integer code, String message) {
        super(cause);
        this.httpCode = httpCode;
        this.code = code;
        this.message = message;
    }

    public Integer getHttpCode() {
        return this.httpCode;
    }

    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

