/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.converter;

import java.util.Date;
import java.util.regex.Pattern;
import net.lulihu.dateTime.DateTimeKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private static final Logger log = LoggerFactory.getLogger(StringToDateConverter.class);

    public Date convert(String dateString) {
        String patternDate = "\\d{4}-\\d{1,2}-\\d{1,2}";
        boolean dateFlag = Pattern.matches(patternDate, dateString);
        if (dateFlag) {
            return DateTimeKit.parseDate((String)dateString);
        }
        String patternTimeMinutes = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
        boolean timeMinutesFlag = Pattern.matches(patternTimeMinutes, dateString);
        if (timeMinutesFlag) {
            return DateTimeKit.parseTimeMinutes((String)dateString);
        }
        String patternTimeSeconds = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        boolean timeSecondsFlag = Pattern.matches(patternTimeSeconds, dateString);
        if (timeSecondsFlag) {
            return DateTimeKit.parseDateTime((String)dateString);
        }
        log.warn("\u65f6\u95f4\u5b57\u7b26\u4e32\u3010{}\u3011\u56e0\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u672a\u80fd\u8f6c\u6362\u4e3aDate\u5bf9\u8c61...");
        return null;
    }
}

