/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.common_util.controller_result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ExceptionEnum;
import net.lulihu.functional.Consumer;
import net.lulihu.functional.ConsumptionResult;

public class Result {
    private Integer code;
    private String message;
    private Object data;

    public Result() {
    }

    public Result(Object data) {
        this(200, "\u8bf7\u6c42\u6210\u529f", data);
    }

    private Result(Integer code, String message) {
        this(code, message, new HashMap());
    }

    private Result(Integer code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static Result success() {
        return Result.result(200, "\u8bf7\u6c42\u6210\u529f");
    }

    public static Result success(Object data) {
        return Result.result(200, "\u8bf7\u6c42\u6210\u529f", data);
    }

    public static Result result(Integer code, String message) {
        return new Result(code, message);
    }

    public static Result result(Integer code, String message, Object data) {
        return new Result(code, message, data);
    }

    public static Result exception(ExceptionEnum ex) {
        return Result.result(ex.getCode(), ex.getMessage());
    }

    public static Result exception(ExceptionEnum ex, Object data) {
        return Result.result(ex.getCode(), ex.getMessage(), data);
    }

    public <T> T getData(Class<T> clazz) {
        return this.getObj(this.data, clazz);
    }

    public <T> List<T> getDataList(Class<T> clazz) {
        return this.getList(this.data, clazz);
    }

    public <T> T getObj(String key, Class<T> clazz) {
        if (this.data == null) {
            return null;
        }
        if (this.data instanceof Map) {
            Object obj = ((Map)this.data).get(key);
            return this.getObj(obj, clazz);
        }
        throw new IllegalArgumentException("\u53c2\u6570\u4e3b\u4f53\u7c7b\u578b\u4e0d\u4e3aMap\u7c7b\u578b\u65e0\u6cd5\u901a\u8fc7\u952e\u83b7\u53d6\u503c");
    }

    private <T> T getObj(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        if (ClassKit.isAssignable(obj.getClass(), clazz)) {
            return (T)obj;
        }
        if (obj instanceof JSONObject) {
            return (T)BeanKit.mapToBean((Map)((JSONObject)obj), clazz);
        }
        throw new IllegalArgumentException(StrKit.format((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u3010{} != {}\u3011", (Object[])new Object[]{obj.getClass(), clazz}));
    }

    private <T> List<T> getList(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (CollectionKit.isEmpty((Collection)list)) {
                return new ArrayList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : list) {
                if (o instanceof JSONObject) {
                    result.add(BeanKit.mapToBean((Map)((JSONObject)o), clazz));
                    continue;
                }
                throw new IllegalArgumentException(StrKit.format((String)"\u4e0d\u652f\u6301\u7684json\u5c01\u88c5\u5bf9\u8c61\u3010{}\u3011", (Object[])new Object[]{o.getClass()}));
            }
            return result;
        }
        throw new IllegalArgumentException(StrKit.format((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u3010{} != {}\u3011", (Object[])new Object[]{obj.getClass(), clazz}));
    }

    public Result put(String key, Object value) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        if (!(this.data instanceof Map)) {
            throw new IllegalArgumentException("\u8be5\u65b9\u6cd5\u53ea\u9650\u4e8e\u4e3b\u4f53\u6570\u636e\u4e3aMap\u7684\u5b9e\u73b0\u7c7b");
        }
        ((Map)this.data).put(key, value);
        return this;
    }

    public Result put(Consumer<Object> consumer) {
        consumer.accept(this.data);
        return this;
    }

    public Result set(ConsumptionResult<Object> consumer) {
        this.data = consumer.accept();
        return this;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

