/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.plugin;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import net.lucypoulton.squirtgun.platform.Platform;
import net.lucypoulton.squirtgun.platform.event.PluginReloadEvent;
import net.lucypoulton.squirtgun.util.SemanticVersion;
import org.jetbrains.annotations.NotNull;

public abstract class SquirtgunPlugin<P extends Platform> {
    private final P platform;

    public SquirtgunPlugin(@NotNull P platform) {
        Preconditions.checkNotNull(platform);
        this.platform = platform;
    }

    public void log(String text) {
        this.getPlatform().log((Component)Component.text((String)("[" + this.getPluginName() + "] " + text)));
    }

    @NotNull
    public P getPlatform() {
        return this.platform;
    }

    @NotNull
    public abstract String getPluginName();

    @NotNull
    public abstract SemanticVersion getPluginVersion();

    @NotNull
    public abstract String[] getAuthors();

    public void reload() {
        this.getPlatform().getEventManager().dispatch(new PluginReloadEvent(this));
    }

    public void onEnable() {
    }

    public void onDisable() {
    }
}

