/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.platform.event;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.lang.reflect.Type;
import java.util.Iterator;
import net.lucypoulton.squirtgun.platform.Platform;
import net.lucypoulton.squirtgun.platform.event.Event;
import net.lucypoulton.squirtgun.platform.event.EventHandler;
import net.lucypoulton.squirtgun.platform.event.EventListener;
import net.lucypoulton.squirtgun.platform.event.cancellable.CancellableEvent;

public class EventManager {
    private final Multimap<Type, EventHandler<?>> handlerMap = MultimapBuilder.hashKeys().treeSetValues().build();
    private final Platform platform;

    public EventManager(Platform platform) {
        this.platform = platform;
    }

    public void register(EventListener listener) {
        for (EventHandler<?> handler : listener.handlers()) {
            this.register(handler);
        }
    }

    public void register(EventHandler<?> handler) {
        this.handlerMap.put(handler.eventType(), handler);
    }

    public void unregister(EventHandler<?> handler) {
        this.handlerMap.remove(handler.eventType(), handler);
    }

    private <T extends Event> void attemptExecution(T event, EventHandler<T> handler) {
        try {
            handler.execute(event);
        }
        catch (Exception e) {
            this.platform.getLogger().severe("Exception thrown while handling " + event.getClass().getName() + ":\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public <T extends Event> Event.Result dispatch(T event) {
        if (event instanceof CancellableEvent) {
            CancellableEvent cancellable = (CancellableEvent)event;
            Iterator iterator = this.handlerMap.get(event.getClass()).iterator();
            while (iterator.hasNext()) {
                EventHandler handler;
                EventHandler handlerCasted = handler = (EventHandler)iterator.next();
                if (!cancellable.willContinue() && !handlerCasted.executesOnCancel()) continue;
                this.attemptExecution(event, handlerCasted);
            }
            return Event.Result.ofCancellable(cancellable);
        }
        for (EventHandler handler : this.handlerMap.get(event.getClass())) {
            this.attemptExecution(event, handler);
        }
        return Event.Result.SUCCESS;
    }
}

