/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.platform.event;

import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.lucypoulton.squirtgun.platform.event.Event;
import net.lucypoulton.squirtgun.platform.event.EventPriority;
import org.jetbrains.annotations.NotNull;

public class EventHandler<T extends Event>
implements Comparable<EventHandler<?>> {
    private final Class<T> eventType;
    private final EventPriority priority;
    private final boolean executeOnCancel;
    private final Consumer<T> handlerMethod;
    private final int id;
    private static final Random random = new Random();

    private EventHandler(int id, Class<T> eventType, EventPriority priority, boolean executeOnCancel, Consumer<T> handlerMethod) {
        this.id = id;
        this.eventType = eventType;
        this.priority = priority;
        this.executeOnCancel = executeOnCancel;
        this.handlerMethod = handlerMethod;
    }

    public Class<T> eventType() {
        return this.eventType;
    }

    public EventPriority priority() {
        return this.priority;
    }

    public boolean executesOnCancel() {
        return this.executeOnCancel;
    }

    public void execute(T event) {
        this.handlerMethod.accept(event);
    }

    public boolean equals(Object obj) {
        return obj instanceof EventHandler && ((EventHandler)obj).id == this.id;
    }

    @Override
    public int compareTo(@NotNull EventHandler<?> o) {
        int byPriority = this.priority().getLevel() - o.priority().getLevel();
        return byPriority == 0 ? this.id - o.id : byPriority;
    }

    public static <T extends Event> Builder<T> builder(Class<T> eventType) {
        return new Builder<T>(eventType);
    }

    public static <T extends Event> EventHandler<T> executes(Class<T> event, Consumer<T> handler) {
        return new EventHandler<T>(random.nextInt(), (Class)event, EventPriority.NORMAL, false, (Consumer)handler){};
    }

    public static class Builder<T extends Event> {
        private final Class<T> eventType;
        private EventPriority priority = EventPriority.NORMAL;
        private boolean executeOnCancel = false;
        private Consumer<T> handlerMethod;

        private Builder(Class<T> eventType) {
            this.eventType = eventType;
        }

        public Builder<T> priority(EventPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder<T> executeOnCancel() {
            this.executeOnCancel = true;
            return this;
        }

        public Builder<T> handle(Consumer<T> method) {
            this.handlerMethod = method;
            return this;
        }

        public EventHandler<T> build() {
            Objects.requireNonNull(this.handlerMethod);
            return new EventHandler<T>(random.nextInt(), this.eventType, this.priority, this.executeOnCancel, this.handlerMethod){};
        }
    }
}

