/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.format.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import net.lucypoulton.squirtgun.format.TextFormatter;
import net.lucypoulton.squirtgun.format.pattern.FormatPattern;
import org.jetbrains.annotations.NotNull;

public final class HsvGradientPattern
implements FormatPattern {
    final Pattern pattern = Pattern.compile("\\{hsv:([A-Fa-f0-9]{6}):?([klmno]+)?>}(.*)\\{([A-Fa-f0-9]{2})<}");

    private static float clamp(float in) {
        if (in > 1.0f) {
            return 1.0f;
        }
        if (in < 0.0f) {
            return 0.0f;
        }
        return in;
    }

    private static Component fade(int hue1, int hue2, int sat, int val, String text, String formats) {
        TextComponent component = Component.empty();
        int[] hues = TextFormatter.fade(text.length(), hue1, hue2);
        for (int x = 0; x < text.length(); ++x) {
            TextColor color = TextColor.color((HSVLike)HSVLike.of((float)(HsvGradientPattern.clamp((float)hues[x] / 255.0f) % 1.0f), (float)HsvGradientPattern.clamp((float)sat / 255.0f), (float)HsvGradientPattern.clamp((float)val / 255.0f)));
            component = component.append((Component)Component.text((char)text.charAt(x), (TextColor)color));
        }
        return TextFormatter.applyLegacyDecorations((Component)component, formats);
    }

    @Override
    public Component process(@NotNull String in, String format) {
        Matcher matcher = this.pattern.matcher(in);
        if (!matcher.find()) {
            return null;
        }
        int hue1 = Integer.parseInt(matcher.group(1).substring(0, 2), 16);
        int sat = Integer.parseInt(matcher.group(1).substring(2, 4), 16);
        int val = Integer.parseInt(matcher.group(1).substring(4, 6), 16);
        int hue2 = Integer.parseInt(matcher.group(4), 16);
        String text = matcher.group(3);
        String formats = format;
        if (formats == null) {
            formats = matcher.group(2);
        }
        return HsvGradientPattern.fade(hue1, hue2, sat, val, text, formats);
    }
}

