/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.format.pattern;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.util.RGBLike;
import net.lucypoulton.squirtgun.format.TextFormatter;
import net.lucypoulton.squirtgun.format.pattern.FormatPattern;
import org.jetbrains.annotations.NotNull;

public final class HexPattern
implements FormatPattern {
    @Override
    public Component process(@NotNull String in, String formats) {
        if (in.length() < 8 || !in.startsWith("{#") || in.charAt(8) != '}') {
            return null;
        }
        for (int i = 2; i < 8; ++i) {
            char c = in.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            return null;
        }
        TextColor colour = TextFormatter.colourFromText(in.substring(1, 8));
        assert (colour != null);
        TextComponent component = Component.text((String)in.substring(9), (TextColor)TextColor.color((RGBLike)colour));
        if (formats != null) {
            for (char c : formats.toCharArray()) {
                component = component.decorate(LegacyComponentSerializer.parseChar((char)c).decoration());
            }
        }
        return component;
    }
}

