/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.argument;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import net.lucypoulton.squirtgun.command.argument.AbstractArgument;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.platform.Platform;
import net.lucypoulton.squirtgun.platform.audience.SquirtgunPlayer;
import org.jetbrains.annotations.Nullable;

public class OnlinePlayerArgument
extends AbstractArgument<SquirtgunPlayer> {
    private final Platform platform;

    public OnlinePlayerArgument(String name, String description, boolean isOptional, Platform platform) {
        super(name, description, isOptional);
        this.platform = platform;
    }

    @Override
    public SquirtgunPlayer getValue(Queue<String> args, CommandContext ctx) {
        String name = args.poll();
        return name == null || "".equals(name) ? null : this.platform.getPlayer(name);
    }

    @Override
    @Nullable
    public List<String> tabComplete(Queue<String> args, CommandContext ctx) {
        String name = args.poll();
        return name == null ? null : this.platform.getOnlinePlayers().stream().map(SquirtgunPlayer::getUsername).filter(username -> username.startsWith(name)).collect(Collectors.toList());
    }
}

